% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_time_to_seconds.R
\name{convert_time_to_seconds}
\alias{convert_time_to_seconds}
\title{Convert time fields to seconds after midnight}
\usage{
convert_time_to_seconds(gtfs, file = NULL, by_reference = FALSE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{file}{A character vector, specifying the file whose fields should be
converted. If \code{NULL} (the default), the function attempts to convert the
times from both files, but only raises an error if none of them exist.}

\item{by_reference}{Whether to update the tables by reference. Defaults to
\code{FALSE}.}
}
\value{
If \code{by_reference} is \code{FALSE}, returns a GTFS object with additional
time in seconds columns (identified by a \verb{_secs} suffix). Else, returns a
GTFS object invisibly (please note that in such case the original GTFS object
is altered).
}
\description{
Converts \code{stop_times}' and \code{frequencies}' fields in the "HH:MM:SS" format to
seconds after midnight. Instead of overwritting the existing fields, creates
new fields with the \verb{_secs} suffix.
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

# by default converts both 'stop_times' and 'frequencies' times
converted_gtfs <- convert_time_to_seconds(gtfs)
head(converted_gtfs$stop_times)
head(converted_gtfs$frequencies)

# choose which table to convert with 'file'
converted_gtfs <- convert_time_to_seconds(gtfs, file = "frequencies")
head(converted_gtfs$stop_times)
head(converted_gtfs$frequencies)

# original gtfs remained unchanged, as seen with the frequencies table above
# change original object without creating a copy with 'by_reference = TRUE'
convert_time_to_seconds(gtfs, by_reference = TRUE)
head(gtfs$stop_times)
head(gtfs$frequencies)

}
