% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_trip_speed.R
\name{set_trip_speed}
\alias{set_trip_speed}
\title{Set trip average speed}
\usage{
set_trip_speed(gtfs, trip_id, speed, unit = "km/h", by_reference = FALSE)
}
\arguments{
\item{gtfs}{A GTFS object, as created by \code{\link[=read_gtfs]{read_gtfs()}}.}

\item{trip_id}{A string vector including the \code{trip_id}s to have their
average speed set.}

\item{speed}{A numeric representing the speed to be set. Its length must
either equal 1, in which case the value is recycled for all
\code{trip_id}s, or equal \code{trip_id}'s length.}

\item{unit}{A string representing the unit in which the speed is given. One
of \code{"km/h"} (the default) or \code{"m/s"}.}

\item{by_reference}{Whether to update \code{stop_times}' \code{data.table} by
reference. Defaults to \code{FALSE}.}
}
\value{
If \code{by_reference} is set to \code{FALSE}, returns a GTFS object with the
time columns of its \code{stop_times} adjusted. Else, returns a GTFS object
invisibly (note that in this case the original GTFS object is altered).
}
\description{
Sets the average speed of each specified \code{trip_id} by changing the
\code{arrival_time} and \code{departure_time} columns in \code{stop_times}.
}
\section{Details}{

The average speed is calculated as the difference between the arrival time
at the last stop minus the departure time at the first top, over the trip's
length (as calculated via \code{\link[=get_trip_geometry]{get_trip_geometry()}}, based on the \code{shapes}
file). The arrival and departure times at all other stops (i.e. not the
first neither the last) are set as \code{""}, which is written as \code{NA} with
\code{\link[=write_gtfs]{write_gtfs()}}. Some transport routing software, such as
\href{http://www.opentripplanner.org/}{OpenTripPlanner}, support specifying stop
times like so. In such cases, they estimate arrival/departure times at the
others stops based on the average speed as well. We plan to add that feature
to this function in the future.
}

\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")

gtfs <- read_gtfs(data_path)

gtfs_new_speed <- set_trip_speed(gtfs, trip_id = "CPTM L07-0", 50)
gtfs_new_speed$stop_times[trip_id == "CPTM L07-0"]

# use the unit argument to change the speed unit
gtfs_new_speed <- set_trip_speed(
  gtfs,
  trip_id = "CPTM L07-0",
  speed = 15,
  unit = "m/s"
)
gtfs_new_speed$stop_times[trip_id == "CPTM L07-0"]

# original gtfs remains unchanged
gtfs$stop_times[trip_id == "CPTM L07-0"]

# when doing by reference, original gtfs is changed
set_trip_speed(gtfs, trip_id = "CPTM L07-0", 50, by_reference = TRUE)
gtfs$stop_times[trip_id == "CPTM L07-0"]

}
