% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtfs_as_sf.R
\name{gtfs_stops_as_sf}
\alias{gtfs_stops_as_sf}
\title{Convert GTFS stops to simple feature object}
\usage{
gtfs_stops_as_sf(gtfs, crs = 4326)
}
\arguments{
\item{gtfs}{A GTFS data.}

\item{crs}{The coordinate reference system represented as an EPSG code.
The default value is 4326 (latlong WGS84)}
}
\value{
A simple feature (sf) object.
}
\description{
Convert a GTFS stops data loaded using gtfs2gps::read_gtf()
into a point simple feature (sf).
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
poa_shapes <- gtfs_shapes_as_sf(poa)
poa_stops <- gtfs_stops_as_sf(poa)
}
