% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_height.R
\name{append_height}
\alias{append_height}
\title{Add a column with height to GPS data}
\usage{
append_height(gps, heightfile)
}
\arguments{
\item{gps}{A GPS data created from gtfs2gps().}

\item{heightfile}{The pathname of a tif file with height data.}
}
\value{
The GPS data with a new column named height.
}
\description{
Add a column named height to GPS data using a tif data as reference.
}
\examples{
library(dplyr)

fortaleza <- system.file("extdata/fortaleza.zip", package = "gtfs2gps")
srtmfile <- system.file("extdata/fortaleza-srtm.tif", package = "gtfs2gps")

gtfs <- read_gtfs(fortaleza) \%>\%
  filter_week_days() \%>\%
  filter_single_trip() \%>\%
  remove_invalid()

fortaleza_gps <- gtfs2gps(gtfs) \%>\% append_height(srtmfile)
}
