% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_cabbeling}
\alias{gsw_cabbeling}
\title{Cabbeling coefficient (48-term equation)}
\usage{
gsw_cabbeling(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ deg C ]}

\item{p}{sea pressure [ dbar ]}
}
\value{
cabbeling coefficient with respect to Conservative Temperature [ 1/(K^2) ]
}
\description{
Cabbeling coefficient (48-term equation)
}
\examples{
SA = c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT = c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
p =  c(     10,      50,     125,     250,     600,    1000)
cabbeling <- gsw_cabbeling(SA,CT,p)
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_cabbeling.html}
}

