% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dist_cavalli}
\alias{dist_cavalli}
\title{Estimation of Bray-Curtis distance}
\usage{
dist_cavalli(x, stratum = "Population")
}
\arguments{
\item{stratum}{The groups among which you are going to estimate genetic distances.}

\item{x}{The genetic data, either as a single locus or multilocus (\code{data.frame})
object.}
}
\value{
A matrix of Cavalli-Sforza Genetic distance estimates.
}
\description{
This function returns a measure of genetic distance based upon
 the Cavalli-Sforza & Edwards (1967)  distance metric.  Assuming
 drift is the only source or differences observed among strata.
}
\examples{
AA <- locus( c("A","A") )
  AB <- locus( c("A","B") )
  BB <- locus( c("B","B") )
  AC <- locus( c("A","C") )
  AD <- locus( c("A","D") )
  BC <- locus( c("B","C") )
  BD <- locus( c("B","D") )
  CC <- locus( c("C","C") )
  CD <- locus( c("C","D") )
  DD <- locus( c("D","D") )
  loc1 <- c(AA,AB,AC,AD,BB,BC,BD,CC,CD,DD)
  loc2 <- c(AA,AA,AC,AA,CC,CC,AC,CC,AA,AC)
  df <- data.frame( Population=c(rep("Pop-A",5),rep("Pop-B",5)), TPI=loc1, PGM=loc2 )
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

