\name{parent_finder}
\alias{parent_finder}
\title{This function finds a set of potential parents from an offspring.}
\usage{
parent_finder(df, ID = "ID", OffID = "OffID")
}
\arguments{
  \item{df}{A \code{data.frame} of individuals adults
  individuals.  This will be the population from which the
  identification of potential parentage will be examined..}

  \item{ID}{The adult "ID" column designator
  (default="ID").  All adults have a unique ID designation.
  This will be how each adult is identified.}

  \item{OffID}{This is a non-zero number for each
  offspring.  The combination of ID and OffID should be
  able to be used to identify each offspring uniquely.  All
  adults have OffID=0, by definition.}
}
\value{
A \code{data.frame} with the following columns.  ID = the
offspring id, OffID = the offspring OffID (these two will
identify the offspring uniquely), ParentID = the putative
parent identified, T = the multilocus transition
probability associated with the offspring and parent.
}
\description{
This is a general exclusion finder for a single parent. For
dual parent exclusion, you can use the \code{paternity()}
function.
}
\author{
Rodney J. Dyer <rjdyer@vcu.edu>
}

