% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{cnv}
\alias{cnv}
\title{Copy Number Variation}
\usage{
cnv(dat, del = -0.1, dup = 0.1)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf" and "rratio" and two vectors "chr" and "pos".}

\item{del}{Lower threshold, everything below is called deletion.}

\item{dup}{Upper threshold, everything above is called duplication.}
}
\description{
Assign copy number variations (duplications and deletions) based on the a threshold.
The CNVs are assigned to all SNPs in a CNV segment.
The CNV segments can be calculated using \code{segm}.
}
\examples{
\dontrun{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
}
}
}

