% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_gsr}
\alias{plot_gsr}
\title{Plot all chromosomes of a sample}
\usage{
plot_gsr(dat, samp, sb = NULL, ncol = NULL, baf = FALSE, tl = FALSE,
  tlcoord = c(1.1, 0.68, 0.32, -0.1), ...)
}
\arguments{
\item{dat}{List object, containing at least two matrices "baf"
and "rratio" and two vectors "chr" and "pos".}

\item{samp}{Integer, which sample should be plotted.}

\item{sb}{Synteny blocks. Data frame with columns start1, start2,
end1, end2, chr1 and chr2.}

\item{ncol}{Number of columns.}

\item{baf}{Logical, if B-Allele frequency should be plotted.}

\item{tl}{Logical, if translocations should be highlighted.}

\item{tlcoord}{Numeric vector of length four. The y-coordinates used to
highlight translocations.
Top and bottom of top translocation and top and bottom of bottom translocation.}

\item{...}{arguments are forwarded to \code{plot()}.}
}
\description{
Plot all chromosomes of a sample.
One subgenome is plotted on top, the other at the bottom.
If available, the synteny plots can be plotted between them.
Genome structure rearrangements (gsr) (e.g.g deletions or duplications) are
highlighted by different colors.
}
\examples{
if(require(brassicaData)){
data("raw_napus", package = "brassicaData", envir = environment())
\dontshow{
raw_napus <- filt_samp(raw_napus, raw_napus$samples[-(1:10)])
raw_napus <- filt_snps(raw_napus, raw_napus$snps[-(1:100)][-(30000:30100)])
}
dat <- intens_theta(raw_napus)
dat <- remove_suffix(dat, "_Grn")
dat <- geno_baf_rratio(dat, delthresh = 11)
dat <- segm(dat)
dat <- cnv(dat, dup = 0.03, del = -0.06)
data("synteny_blocks", package = "brassicaData", envir = environment())
plot_gsr(dat, samp = 1, sb = synteny_blocks)
}
}

