% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_poisson.R
\name{LL_poisson}
\alias{LL_poisson}
\title{Poisson regression log-likelihood}
\usage{
LL_poisson(y, x, mod)
}
\arguments{
\item{y}{numeric vector recording a count dependent variable.}

\item{x}{data.frame (or matrix) containing predictor values.}

\item{mod}{\code{glm} object containing the estimated poisson regression model.}
}
\value{
A list containing:
\itemize{
\item \code{ll} an atomic vector of length 1 containing the log-likelihood value.
\item \code{sc} an atomic vector containing the systematic component for the input \code{x} and \code{mod}.
}
}
\description{
Computes the Poisson regression log-likelihood of a vector of observed values given the GLM systematic component.
}
\details{
If \code{x} and \code{y} are equal to the data on which \code{mod} has been trained, this function returns the same result as the default \code{logLink} function. If \code{x} and \code{y} are new, the function returns the log-likelihood of the new data under the trained model.
}
\references{
Agresti, A. (2012). Categorical data analysis (Vol. 792). John Wiley & Sons.
}
\author{
Edoardo Costantini, 2023
}
