% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf2zp.R
\name{tf2zp}
\alias{tf2zp}
\title{Transfer function to zero-pole-gain form}
\usage{
tf2zp(b, a)
}
\arguments{
\item{b}{moving average (MA) polynomial coefficients, specified as a numeric
vector or matrix. In case of a matrix, then each row corresponds to an
output of the system. The number of columns of \code{b} must be less than
or equal to the length of \code{a}.}

\item{a}{autoregressive (AR) polynomial coefficients, specified as a vector.}
}
\value{
A list of class Zpg with the following list elements:
\describe{
  \item{z}{complex vector of the zeros of the model (roots of \code{B(z)})}
  \item{p}{complex vector of the poles of the model (roots of \code{A(z)})}
  \item{g}{overall gain (\code{B(Inf)})}
}
}
\description{
Convert digital filter transfer function parameters to zero-pole-gain form.
}
\examples{
b <- c(2, 3)
a <- c(1, 1/sqrt(2), 1/4)
zpk <- tf2zp(b, a)

}
\seealso{
\code{\link{filter}}
}
\author{
Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
