% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgolayfilt.R
\name{filter.sgolayFilter}
\alias{filter.sgolayFilter}
\alias{sgolayfilt}
\title{Savitzky-Golay filtering}
\usage{
\method{filter}{sgolayFilter}(filt, x, ...)

sgolayfilt(x, p = 3, n = p + 3 - p\%\%2, m = 0, ts = 1)
}
\arguments{
\item{filt}{Filter characteristics, usually the result of a call to
\code{sgolay}}

\item{x}{the input signal to be filtered, specified as a vector or as a
matrix. If \code{x} is a matrix, each column is filtered.}

\item{...}{Additional arguments (ignored)}

\item{p}{Polynomial filter order; must be smaller than \code{n}.}

\item{n}{Filter length; must a an odd positive integer.}

\item{m}{Return the m-th derivative of the filter coefficients. Default: 0}

\item{ts}{Scaling factor. Default: 1}
}
\value{
The filtered signal, of the same dimensions as the input signal.
}
\description{
Filter a signal with a Savitzky-Golay FIR filter.
}
\details{
Savitzky-Golay smoothing filters are typically used to "smooth out" a noisy
signal whose frequency span (without noise) is large. They are also called
digital smoothing polynomial filters or least-squares smoothing filters.
Savitzky-Golay filters perform better in some applications than standard
averaging FIR filters, which tend to filter high-frequency content along with
the noise. Savitzky-Golay filters are more effective at preserving high
frequency signal components but less successful at rejecting noise.

Savitzky-Golay filters are optimal in the sense that they minimize the
least-squares error in fitting a polynomial to frames of noisy data.
}
\examples{
# Compare a 5 sample averager, an order-5 butterworth lowpass
# filter (cutoff 1/3) and sgolayfilt(x, 3, 5), the best cubic
# estimated from 5 points.
bf <- butter(5, 1/3)
x <- c(rep(0, 15), rep(10, 10), rep(0, 15))
sg <- sgolayfilt(x)
plot(sg, type="l", xlab = "", ylab = "")
lines(filtfilt(rep(1, 5) / 5, 1, x), col = "red") # averaging filter
lines(filtfilt(bf, x), col = "blue")              # butterworth
points(x, pch = "x")                              # original data
legend("topleft", c("sgolay (3,5)", "5 sample average", "order 5
Butterworth", "original data"), lty=c(1, 1, 1, NA),
pch = c(NA, NA, NA, "x"), col = c(1, "red", "blue", 1))

}
\seealso{
\code{\link{sgolay}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R Tom Short,\cr
adapted by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
