% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invimpinvar.R
\name{invimpinvar}
\alias{invimpinvar}
\alias{invimpinvar.Arma}
\alias{invimpinvar.default}
\title{Inverse impulse invariance method}
\usage{
invimpinvar(b, ...)

\method{invimpinvar}{Arma}(b, ...)

\method{invimpinvar}{default}(b, a, fs = 1, tol = 1e-04, ...)
}
\arguments{
\item{b}{coefficients of numerator polynomial}

\item{...}{additional arguments (not used)}

\item{a}{coefficients of denominator polynomial}

\item{fs}{sampling frequency (Default: 1 Hz)}

\item{tol}{tolerance. Default: 0.0001}
}
\value{
A list of class \code{\link{Arma}} containing numerator and
  denominator polynomial filter coefficients of the A/D converted filter.
}
\description{
Convert digital filter with coefficients b and a to analog, conserving
impulse response.
}
\details{
Because \code{invimpinvar} is generic, it can also accept input of class
\code{\link{Arma}}.
}
\examples{
f <- 2
fs <- 10
but <- butter(6, 2 * pi * f, 'low', 's')
zbut <- impinvar(but, fs)
sbut <- invimpinvar(zbut, fs)
all.equal(but, sbut, tolerance = 1e-7)

}
\references{
Thomas J. Cavicchi (1996) Impulse invariance and multiple-order
  poles. IEEE transactions on signal processing, Vol 40 (9): 2344--2347.
}
\seealso{
\code{\link{impinvar}}
}
\author{
R.G.H. Eschauzier, \email{reschauzier@yahoo.com},\cr
 Carne Draug, \email{carandraug+dev@gmail.com}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}
}
