% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqs_plot.R
\name{freqs_plot}
\alias{freqs_plot}
\title{Plot frequency response}
\usage{
freqs_plot(w, h, ...)
}
\arguments{
\item{w}{angular frequencies, specified as a positive real vector expressed
in rad/second.}

\item{h}{Frequency response, specified as a complex vector.}

\item{...}{additional arguments passed to the \code{plot() function}}
}
\value{
No return value
}
\description{
Plot the s-plane frequency response of an IIR filter.
}
\examples{
b <- c(1, 2); a <- c(1, 1)
w <- seq(0.01, 4, length.out = 128)
h <- freqs (b, a, w, plot = FALSE)
freqs_plot(w, h)
freqs_plot(w, h, log = "x")

}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel \email{gjmvanboxtel@gmail.com}
}
