% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fht.R
\name{fht}
\alias{fht}
\alias{ifht}
\title{Fast Hartley Transform}
\usage{
fht(x, n = NROW(x))

ifht(x, n = NROW(x))
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{n}{transform length, specified as a positive integer scalar. Default:
\code{NROW(x)}.}
}
\value{
(inverse) Hartley transform, returned as a vector or matrix.
}
\description{
Compute the (inverse) Hartley transform of a signal using FFT
}
\details{
The Hartley transform is an integral transform closely related to the Fourier
transform, but which transforms real-valued functions to real-valued
functions. Compared to the Fourier transform, the Hartley transform has
the advantages of transforming real functions to real functions (as opposed
to requiring complex numbers) and of being its own inverse [1].

This function implements the Hartley transform by calculating the difference
between the real- and imaginary-valued parts of the Fourier-transformed
signal [1]. The forward and inverse Hartley transforms are the same (except
for a scale factor of 1/N for the inverse Hartley transform), but implemented
using different functions.
}
\examples{
# FHT of a 2.5 Hz signal with offset
fs <- 100
secs <- 10
freq <- 2.5
t <- seq(0, secs - 1 / fs, 1 / fs)
x <- 5 * t + 50 * cos(freq * 2 * pi * t)
X <- fht(x)
op <- par(mfrow = c(2, 1))
plot(t, x, type = "l", xlab = "", ylab = "", main = "Signal")
f <- seq(0, fs - (1 / fs), length.out = length(t))
to <- which(f >= 5)[1]
plot(f[1:to], X[1:to], type = "l", xlab = "", ylab = "",
     main = "Hartley Transform")
par(op)

}
\references{
[1] \url{https://en.wikipedia.org/wiki/Hartley_transform}
}
\seealso{
\code{\link{fft}}
}
\author{
Muthiah Annamalai, \email{muthiah.annamalai@uta.edu}.\
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
