% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fftconv.R
\name{fftconv}
\alias{fftconv}
\title{FFT-based convolution}
\usage{
fftconv(x, y, n = NULL)
}
\arguments{
\item{x, y}{input vectors.}

\item{n}{FFT length, specified as a positive integer. The FFT size must be an
even power of 2 and must be greater than or equal to the length of
\code{filt}. If the specified \code{n} does not meet these criteria, it is
automatically adjusted to the nearest value that does. If \code{n = NULL}
(default), then the overlap-add method is not used.}
}
\value{
Convoluted signal, specified as a a vector of length equal to
  \code{length (x) + length (y) - 1}. If \code{x} and \code{y} are the
  coefficient vectors of two polynomials, the returned value is the
  coefficient vector of the product polynomial.
}
\description{
Convolve two vectors using the FFT for computation.
}
\details{
The computation uses the FFT by calling the function \code{fftfilt}. If the
optional argument \code{n} is specified, an \code{n}-point overlap-add FFT is
used.
}
\examples{

u <- rep(1L, 3)
v <- c(1, 1, 0, 0, 0, 1, 1)
w1 <- conv(u, v)              # time-domain convolution
w2 <- fftconv(u, v)           # frequency domain convolution
all.equal(w1, w2)             # same results

}
\seealso{
\code{\link{conv}}, \code{\link{conv2}}
}
\author{
Kurt Hornik, \email{Kurt.Hornik@wu-wien.ac.at},\cr
 adapted by John W. Eaton.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
