% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cconv.R
\name{cconv}
\alias{cconv}
\title{Circular convolution}
\usage{
cconv(a, b, n = length(a) + length(b) - 1)
}
\arguments{
\item{a, b}{Input, coerced to vectors, can be different lengths or data types.}

\item{n}{Convolution length, specified as a positive integer. Default:
\code{length(a) + length(b) - 1}.}
}
\value{
Circular convolution of input vectors, returned as a vector.
}
\description{
Compute the modulo-n circular convolution.
}
\details{
Linear and circular convolution are fundamentally different operations.
Linear convolution of an n-point vector x, and an l-point vector y, has
length n + l - 1, and can be computed by the function \code{\link{conv}},
which uses \code{\link{filter}}. The circular convolution, by contrast, is
equal to the inverse discrete Fourier transform (DFT) of the product of the
vectors' DFTs.

For the circular convolution of \code{x} and \code{y} to be equivalent to
their linear convolution, the vectors must be padded with zeros to length at
least \code{n + l - 1} before taking the DFT. After inverting the product of
the DFTs, only the first \code{n + l - 1} elements should be retained.

For long sequences circular convolution may be more efficient than linear
convolution. You can also use \code{cconv} to compute the circular
cross-correlation of two sequences.
}
\examples{
a <- c(1, 2, -1, 1)
b <- c(1, 1, 2, 1, 2, 2, 1, 1)
c <- cconv(a, b)       # Circular convolution
cref = conv(a, b)      # Linear convolution
all.equal(max(c - cref), 0)

cconv(a, b, 6)

}
\seealso{
\code{\link{conv}}, \code{\link[stats]{convolve}}
}
\author{
Leonardo Araujo.\cr Conversion to R by Geert van Boxtel,
  \email{G.J.M.vanBoxtel@gmail.com}.
}
