% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcar.R
\name{boxcar}
\alias{boxcar}
\title{Rectangular window}
\usage{
boxcar(n)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}
}
\value{
rectangular window, returned as a vector.
}
\description{
Return the filter coefficients of a boxcar (rectangular) window.
}
\details{
The rectangular window (sometimes known as the boxcar or Dirichlet window) is
the simplest window, equivalent to replacing all but \code{n} values of a
data sequence by zeros, making it appear as though the waveform suddenly
turns on and off. Other windows are designed to moderate these sudden
changes, which reduces scalloping loss and improves dynamic range.
}
\examples{

b <- boxcar(64)
plot (b, type = "l", xlab = "Samples", ylab =" Amplitude")

}
\seealso{
\code{\link{triang}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
