% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arma.R
\name{Arma}
\alias{Arma}
\alias{as.Arma}
\alias{as.Arma.Arma}
\alias{as.Arma.Ma}
\alias{as.Arma.Sos}
\alias{as.Arma.Zpg}
\title{Autoregressive moving average (ARMA) model}
\usage{
Arma(b, a)

as.Arma(x, ...)

## S3 method for class 'Arma'
as.Arma(x, ...)

## S3 method for class 'Ma'
as.Arma(x, ...)

## S3 method for class 'Sos'
as.Arma(x, ...)

## S3 method for class 'Zpg'
as.Arma(x, ...)
}
\arguments{
\item{b}{moving average (MA) polynomial coefficients.}

\item{a}{autoregressive (AR) polynomial coefficients.}

\item{x}{model or filter to be converted to an ARMA representation.}

\item{...}{additional arguments (ignored).}
}
\value{
A list of class \code{'Arma'} with the following list elements:
\describe{
  \item{b}{moving average (MA) polynomial coefficients}
  \item{a}{autoregressive (AR) polynomial coefficients}
}
}
\description{
Create an ARMA model representing a filter or system model, or
convert other forms to an ARMA model.
}
\details{
The ARMA model is defined by:
\deqn{a(L)y(t) = b(L)x(t)}
The ARMA model can define an analog or digital model. The AR and MA
polynomial coefficients follow the convention in 'Matlab' and 'Octave' where
the coefficients are in decreasing order of the polynomial (the opposite of
the definitions for \code{\link[stats]{filter}}filter and
\code{\link[base]{polyroot}}). For an analog model,
\if{latex}{
 \deqn{H(s) = (b_1 s^{(m-1)} + b_2 s^{(m-2)} + \ldots + b_m) / (a_1 s^{(n-1)}
 + a_2 s^{(n-2)} + \ldots + a_n)}
}
\if{html}{\preformatted{
  H(s) = (b[1]*s^(m-1) + b[2]*s^(m-2) + ... + b[m]) / (a[1]*s^(n-1) +
  a[2]*s^(n-2) + ... + a[n])
}}
For a z-plane digital model,
\if{latex}{
 \deqn{H(z) = (b_1 + b_2 z^{-1} + \ldots + b_m z^{(-m+1)}) / (a_1 + a_2
 z^{-1} + \ldots + a_n z^{(-n+1)})}
}
\if{html}{\preformatted{
  H(z) = (b[1] + b[2]*z^(-1) + … + b[m]*z^(-m+1)) / (a[1] + a[2]*z^(-1) + … +
  a[n]*z^(-n+1))
}}


\code{as.Arma} converts from other forms, including \code{Zpg} and \code{Ma}.
}
\examples{
filt <- Arma(b = c(1, 2, 1)/3, a = c(1, 1))
zplane(filt)

}
\seealso{
See also \code{\link{Zpg}}, \code{\link{Ma}}, \code{\link{filter}},
  and various filter-generation functions like \code{\link{butter}} and
  \code{\link{cheby1}} that return Arma models.
}
\author{
Tom Short, \email{tshort@eprisolutions.com},\cr
adapted by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}.
}
