% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_gt.R
\name{as_gt}
\alias{as_gt}
\alias{as_gt.fixed_design}
\alias{as_gt.gs_design}
\title{Convert summary table of a fixed or group sequential design object to a gt object}
\usage{
as_gt(x, ...)

\method{as_gt}{fixed_design}(x, title = NULL, footnote = NULL, ...)

\method{as_gt}{gs_design}(
  x,
  title = NULL,
  subtitle = NULL,
  colname_spanner = "Cumulative boundary crossing probability",
  colname_spannersub = c("Alternate hypothesis", "Null hypothesis"),
  footnote = NULL,
  display_bound = c("Efficacy", "Futility"),
  display_columns = NULL,
  display_inf_bound = FALSE,
  full_alpha = 0.025,
  ...
)
}
\arguments{
\item{x}{A summary object of a fixed or group sequential design.}

\item{...}{Additional arguments (not used).}

\item{title}{A string to specify the title of the gt table.}

\item{footnote}{A list containing \code{content}, \code{location}, and \code{attr}.
\code{content} is a vector of string to specify the footnote text;
\code{location} is a vector of string to specify the locations to put the
superscript of the footnote index;
\code{attr} is a vector of string to specify the attributes of the footnotes,
for example, \code{c("colname", "title", "subtitle", "analysis", "spanner")};
users can use the functions in the \code{gt} package to customize the table.}

\item{subtitle}{A string to specify the subtitle of the gt table.}

\item{colname_spanner}{A string to specify the spanner of the gt table.}

\item{colname_spannersub}{A vector of strings to specify the spanner details of the gt table.}

\item{display_bound}{A vector of strings specifying the label of the bounds.
The default is \code{c("Efficacy", "Futility")}.}

\item{display_columns}{A vector of strings specifying the variables to be
displayed in the summary table.}

\item{display_inf_bound}{Logical, whether to display the +/-inf bound.}

\item{full_alpha}{The full alpha used in the design, the default is 0.025.
when the futility bound is non-binding, a footnote will be displayed, saying
the smaller value subtracts the probability of crossing a futility bound before
crossing an efficacy bound at a later analysis under the null hypothesis.}
}
\value{
A \code{gt_tbl} object.
}
\description{
Convert summary table of a fixed or group sequential design object to a gt object
}
\examples{
\dontshow{if (interactive() && !identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

# Enrollment rate
enroll_rate <- define_enroll_rate(
  duration = 18,
  rate = 20
)

# Failure rates
fail_rate <- define_fail_rate(
  duration = c(4, 100),
  fail_rate = log(2) / 12,
  dropout_rate = .001,
  hr = c(1, .6)
)

# Study duration in months
study_duration <- 36

# Experimental / Control randomization ratio
ratio <- 1

# 1-sided Type I error
alpha <- 0.025

# Type II error (1 - power)
beta <- 0.1

# Example 1 ----
fixed_design_ahr(
  alpha = alpha, power = 1 - beta,
  enroll_rate = enroll_rate, fail_rate = fail_rate,
  study_duration = study_duration, ratio = ratio
) \%>\%
  summary() \%>\%
  as_gt()

# Example 2 ----
fixed_design_fh(
  alpha = alpha, power = 1 - beta,
  enroll_rate = enroll_rate, fail_rate = fail_rate,
  study_duration = study_duration, ratio = ratio
) \%>\%
  summary() \%>\%
  as_gt()
\dontshow{\}) # examplesIf}
\dontshow{if (interactive() && !identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
# Example 1 ----
# The default output

gs_design_ahr() \%>\%
  summary() \%>\%
  as_gt()

gs_power_ahr() \%>\%
  summary() \%>\%
  as_gt()

gs_design_wlr() \%>\%
  summary() \%>\%
  as_gt()

gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt()

gs_power_combo() \%>\%
  summary() \%>\%
  as_gt()

gs_design_rd() \%>\%
  summary() \%>\%
  as_gt()

gs_power_rd() \%>\%
  summary() \%>\%
  as_gt()

# Example 2 ----
# Usage of title = ..., subtitle = ...
# to edit the title/subtitle
gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt(
    title = "Bound Summary",
    subtitle = "from gs_power_wlr"
  )

# Example 3 ----
# Usage of colname_spanner = ..., colname_spannersub = ...
# to edit the spanner and its sub-spanner
gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt(
    colname_spanner = "Cumulative probability to cross boundaries",
    colname_spannersub = c("under H1", "under H0")
  )

# Example 4 ----
# Usage of footnote = ...
# to edit the footnote
gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt(
    footnote = list(
      content = c(
        "approximate weighted hazard ratio to cross bound.",
        "wAHR is the weighted AHR.",
        "the crossing probability.",
        "this table is generated by gs_power_wlr."
      ),
      location = c("~wHR at bound", NA, NA, NA),
      attr = c("colname", "analysis", "spanner", "title")
    )
  )

# Example 5 ----
# Usage of display_bound = ...
# to either show efficacy bound or futility bound, or both(default)
gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt(display_bound = "Efficacy")

# Example 6 ----
# Usage of display_columns = ...
# to select the columns to display in the summary table
gs_power_wlr() \%>\%
  summary() \%>\%
  as_gt(display_columns = c("Analysis", "Bound", "Nominal p", "Z", "Probability"))
\dontshow{\}) # examplesIf}
}
