% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design_mb.R
\name{fixed_design_mb}
\alias{fixed_design_mb}
\title{Fixed design using Magirr-Burman method}
\usage{
fixed_design_mb(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  tau = 6
)
}
\arguments{
\item{alpha}{One-sided Type I error.}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio.}

\item{study_duration}{Study duration.}

\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{tau}{Test parameter of Magirr-Burman method.}
}
\value{
A table.
}
\description{
Computes fixed design sample size (given power) or power (given sample size)
for Magirr-Burman method.
Returns a list with a basic summary.
}
\examples{
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_mb(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 4
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_mb(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 4
)
x \%>\% summary()
}
