% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lambdaMC}
\alias{lambdaMC}
\title{Monte Carlo based adjustment of the SLOPE tuning parameters}
\usage{
lambdaMC(lambda_BH, X, lambda_length, number_of_drawings = 5000L)
}
\arguments{
\item{lambda_BH}{The regualrizing sequence as used in Theorem 1.1 in Bogdan et. al. (2015)}

\item{X}{The model matrix}

\item{lambda_length}{The corrections of the entries of \code{lambda_BH} will be 
computed up to the index given by \code{lambda_length} only.}

\item{number_of_drawings}{The number of iterations in the Monte Carlo procedure}
}
\description{
\code{lambdaMC} adjusts the SLOPE regularizing sequence for correlations in 
   the data via a Monte Carlo approach which assumes normality of the error terms.
}
\references{
M. Bogdan, E. van den Berg, C. Sabatti, W. Su, E. Candes (2015), \emph{SLOPE -- Adaptive variable selection via convex optimization}, \url{http://arxiv.org/abs/1407.3824}
}

