% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cluster.R
\name{plot_cluster}
\alias{plot_cluster}
\title{Plot estimated functions, facetted by cluster numbers, for a known clustering}
\usage{
plot_cluster(
  y,
  H,
  sort = FALSE,
  sample_rate = 0.05,
  y.axis.label = NULL,
  smoother = TRUE,
  fade = 0.2,
  cluster_order = NULL,
  plot_render = TRUE
)
}
\arguments{
\item{y}{An \code{N x T} matrix for a collection of functions.}

\item{H}{An \code{N x 1} with entries in \code{1,...,M} of cluster assignments for the \code{N}
units of \code{y} under a known clustering.}

\item{sort}{An optional boolean input on whether to sort the cluster-indexed plot panels 
of function by size of cluster.  Defaults \code{sort = FALSE}.}

\item{sample_rate}{An optional numeric value in (0,1] indicating percent of functions to 
randomly sample within each cluster to address over-plotting.  Defaults to 1.}

\item{y.axis.label}{An optional text label for y-axis. Defaults to \code{"function values"}.}

\item{smoother}{An optional scalar boolean input indicating whether to co-plot a smoother line 
through the functions in each cluster.}

\item{fade}{An optional numeric input in \code{(0,1)} indicating the degree of fading to apply to the
plots of functions in each cluster-indexed panel.  Defaults to \code{fade = 0.2}.}

\item{cluster_order}{An optional numeric vector of length \code{M}, the number of clusters, 
indicating the order, from-to-right, for plotting the cluster-indexed panels.}

\item{plot_render}{An optional boolean input indicating whether to render the plot.
Defaults to \code{plot_render = TRUE}.}
}
\value{
A list object containing the plot of estimated functions, faceted by cluster,
    	and the associated \code{data.frame} object.
    \item{p.basis}{A \code{ggplot2} plot object}
    \item{map}{A \code{data.frame} object listing the unit and associated cluster membership.}
}
\description{
An internal function of the \code{growfunctions} package.
}
\seealso{
\code{\link{gpdpgrow}}, \code{\link{gmrfdpgrow}}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
