% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_aov.R
\name{grouped_aov}
\alias{grouped_aov}
\title{Function to run analysis of variance (aov) across multiple grouping
variables.}
\usage{
grouped_aov(data, grouping.vars, formula, effsize = "eta",
  output = "tidy", nboot = 1000)
}
\arguments{
\item{data}{Dataframe from which variables are to be taken.}

\item{grouping.vars}{List of grouping variables.}

\item{formula}{A formula specifying the model.}

\item{effsize}{Character describing the effect size to be displayed: \code{"eta"}
(default) or \code{"omega"}.}

\item{output}{A character describing what output is expected. Two possible
options: \code{"tidy"} (default), which will return the results, or \code{"tukey"},
which will return results from Tukey's Honest Significant Differences
method for \emph{post hoc} comparisons. The \code{"glance"} method to get model
summary is currently not supported for this function.}

\item{nboot}{Number of bootstrap samples for confidence intervals for partial
eta-squared and omega-squared (Default: \code{500}).}
}
\value{
A tibble dataframe with tidy results from anova. No model summaries
available.
}
\description{
Function to run analysis of variance (aov) across multiple grouping
variables.
}
\examples{

# uses dataset included in the groupedstats package
set.seed(123)
library(groupedstats)

groupedstats::grouped_aov(
  formula = rating ~ belief * outcome * question,
  data = intent_morality,
  grouping.vars = item,
  effsize = "eta"
)
}
\author{
Indrajeet Patil
}
