% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.R
\name{alter_at}
\alias{alter_at}
\title{Alter aesthetics / structures at certain areas of a grob matrix}
\usage{
alter_at(
  grob_object,
  .f = NULL,
  ...,
  columns = NULL,
  rows = NULL,
  data = NULL,
  structure = NULL,
  aesthetic = NULL,
  group = NULL
)
}
\arguments{
\item{grob_object}{The R6 grob object class initialized by \code{\link{grob_matrix}}.}

\item{.f}{A quosure style lambda \code{~ fun(.)}, which the user wants to apply
to the specific subset of cells.}

\item{...}{Logical predicates defined in terms of the variables in the initial 
data frame / matrix, or if the user provides a new data.frame to evaluate via 
\code{data}. Multiple conditions are combined with \code{&}. Only rows where the condition 
evaluates to TRUE are evaluated. 

If no logical predicates provided, then the entire columns will be altered.}

\item{columns}{A character vector of column names, or numeric column indices,
of the initial data.frame/matrix, or \code{data} if it is provided, the user wishes to alter.}

\item{rows}{A numeric vector of row indices, of the initial data.frame/matrix, 
or \code{data} if it is provided, the user wishes to alter.

Ignored if the user is altering a structure and not an aesthetic.}

\item{data}{A separate data.frame/matrix of the same dimensions as the initial 
data.frame/matrix which the \code{.f} function and any filters will be applied to.

Must match the dimensions of the subset of the initial data.frame/matrix the user
is attempting to alter.

Ignored if the user is altering a structure and not an aesthetic.}

\item{structure}{Which structure the user wants to make alterations to. If left 
\code{NULL} and \code{aesthetic} is left \code{NULL}, the function will 
look for the most previous altered structure, either via 
\code{\link{add_structure}}, or a previous application of \code{alter_at}.

View the documentation of \code{\link{add_structure}} for a list of accepted 
structures}

\item{aesthetic}{Which aesthetic the user wants to make alterations to. If left 
\code{NULL} and \code{structure} is left \code{NULL}, the function will 
look for the most previous altered aesthetic, either via 
\code{\link{add_aesthetic}}, or a previous application of \code{alter_at}.

View the documentation of \code{\link{add_aesthetic}} for a list of accepted 
aesthetics.}

\item{group}{Which group of elements the user wants to make alterations to. If left 
\code{NULL}, the function will look for the most previous altered group, either
via \code{\link{add_aesthetic}}, or a previous application of \code{alter_at}.}
}
\value{
The R6 grob matrix object class with its aesthetic / structure properties altered.
}
\description{
Flexibly alter the aesthetic / structure of a grob matrix object at specific points of
the data.frame/matrix.
}
\examples{

df = data.frame(var1 = c(5, 14, 6, 10), var2 = c(3, 30, 17, 7))
df \%>\%
  grob_matrix() \%>\%
  add_aesthetic(aesthetic = 'text_color', group = 'cells', value = 'red') \%>\%
  alter_at(
    .f = ~ 'blue',
    abs(var2 - var1) > 1
    ) \%>\%
  view_grob()

test_function = function(x) ifelse(x > 15, 2, 1)

df \%>\%
  grob_matrix() \%>\%
  alter_at(
    .f = ~ test_function(.),
    aesthetic = 'font_face',
    group = 'cells'
    ) \%>\%
  view_grob()
  
df \%>\%
  grob_matrix() \%>\%
  add_structure("column_widths_p", 1) \%>\%
  alter_at(
    .f = ~ 2,
    columns = 1
    ) \%>\%
  view_grob()
  

}
