% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-geometry-regular_polygon.R
\name{grid.pattern_regular_polygon}
\alias{grid.pattern_regular_polygon}
\title{Regular polygon patterned grobs}
\usage{
grid.pattern_regular_polygon(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  colour = gp$col \%||\% "grey20",
  fill = gp$fill \%||\% "grey80",
  angle = 30,
  density = 0.2,
  spacing = 0.05,
  xoffset = 0,
  yoffset = 0,
  units = "snpc",
  scale = 0.5,
  shape = "convex4",
  grid = "square",
  type = NULL,
  subtype = NULL,
  rot = 0,
  alpha = gp$alpha \%||\% NA_real_,
  linetype = gp$lty \%||\% 1,
  linewidth = size \%||\% gp$lwd \%||\% 1,
  size = NULL,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored.}

\item{colour}{Stroke colour(s).}

\item{fill}{Fill colour(s) or \code{\link[grid:patterns]{grid::pattern()}} / gradient object(s).}

\item{angle}{Rotation angle in degrees.}

\item{density}{Approx. fraction of area the pattern fills.}

\item{spacing}{Spacing between repetitions of pattern (in \code{units} units).}

\item{xoffset}{Shift pattern along x axis (in \code{units} units).}

\item{yoffset}{Shift pattern along y axis (in \code{units} units).}

\item{units}{\code{\link[grid:unit]{grid::unit()}} units for \code{spacing}, \code{xoffset}, and \code{yoffset} parameters.}

\item{scale}{For star polygons, multiplier (between 0 and 1)
applied to exterior radius to get interior radius.}

\item{shape}{Either "convex" or "star" followed by the number of exterior vertices
or alternatively "circle", "square", "null", "rhombille_rhombus",
"tetrakis_left", or "tetrakis_right".
For example "convex5" corresponds to a pentagon
and "star6" corresponds to a six-pointed star.
The "square" shape is larger than the "convex4" shape and is rotated an extra 45 degrees,
it can be used to generate a multi-colored \dQuote{checkers} effect when density is 1.
The "null" shape is not drawn, it can be used to create holes within multiple-element patterns.
The "rhombille_rhombus" shape draws a rhombus while the
"tetrakis_left" or "tetrakis_right" shapes draw an isosceles right triangle.
These latter three non-regular-polygon shapes are
intended to help generate rhombille and tetrakis square tilings.}

\item{grid}{Adjusts placement and density of certain graphical elements.
\code{"square"} (default) is a square grid.
\code{"hex"} is a hexagonal grid suitable for hexagonal and triangular tiling.
\code{"hex_circle"} is a hexagonal grid suitable for circle packing.
\code{"elongated_triangle"} is a grid used for the "elongated triangle" tiling.}

\item{type}{Adjusts the repeating of certain aesthetics such as color.
Can use any type in \code{names_hex}, \code{names_square}, or \code{names_weave}.
See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{type} arguments.}

\item{subtype}{See for \code{\link[=pattern_hex]{pattern_hex()}}, \code{\link[=pattern_square]{pattern_square()}}, and \code{\link[=pattern_weave]{pattern_weave()}} for
more information about supported \code{subtype} arguments.}

\item{rot}{Angle to rotate regular polygon (degrees, counter-clockwise).}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{linetype}{Stroke linetype.}

\item{linewidth}{Stroke linewidth.}

\item{size}{For backwards compatibility can be used to set \code{linewidth}.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_regular_polygon()} draws a regular polygon pattern onto the graphic device.
}
\examples{
x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))

# 'density', 'rot', and 'shape' are vectorized
grid.pattern_regular_polygon(x_hex, y_hex, colour = "black",
                             fill = c("blue", "yellow", "red"),
                             shape = c("convex4", "star8", "circle"),
                             density = c(0.45, 0.42, 0.4),
                             spacing = 0.08, angle = 0)

# checker pattern using "square" shape
grid::grid.newpage()
grid.pattern_regular_polygon(x_hex, y_hex, shape = "square",
                             colour = "transparent",
                             fill = c("black", "red", "blue", "yellow"),
                             angle = 0, density = 1.0, spacing = 0.2)

# checker pattern using the default "convex4" shape
grid::grid.newpage()
grid.pattern_regular_polygon(x_hex, y_hex, density = 1.0,
                             colour = "black", fill = "blue")

# using a "twill_zigzag" 'weave' pattern
grid::grid.newpage()
grid.pattern_regular_polygon(x_hex, y_hex, fill = c("blue", "yellow"),
                             shape = c("circle", "star8"),
                             density = c(0.5, 0.6), type = "twill_zigzag")

# hexagon tiling
grid::grid.newpage()
grid.pattern_regular_polygon(x_hex, y_hex, color = "transparent",
                             fill = c("white", "grey", "black"),
                             density = 1.0, spacing = 0.1,
                             shape = "convex6", grid = "hex")

# triangle tiling
grid::grid.newpage()
grid.pattern_regular_polygon(x_hex, y_hex, fill = "green",
                             density = 1.0, spacing = 0.1,
                             shape = "convex3", grid = "hex")
}
\seealso{
\code{\link[=grid.pattern_circle]{grid.pattern_circle()}} for a special case of this pattern.
The tiling vignette features more examples of regular polygon tiling using
this function \code{vignette("tiling", package = "gridpattern")}.
}
