% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern_hex.R
\docType{data}
\name{pattern_hex}
\alias{pattern_hex}
\alias{names_hex}
\title{Hex pattern matrix}
\format{
An object of class \code{character} of length 5.
}
\usage{
pattern_hex(type = "hex", subtype = NULL, nrow = 5L, ncol = 5L)

names_hex
}
\arguments{
\item{type}{Currently just supports "hex".}

\item{subtype}{An integer indicating number of colors (or other graphical elements).}

\item{nrow}{Number of rows (height).}

\item{ncol}{Number of columns (width).}
}
\value{
A matrix of integer values indicating where the each color
or other graphical elements should be drawn on a horizontal hex grid
(i.e. hexagons are assumed to be pointy side up).
Indices \verb{[1,1]} of the matrix corresponds to the bottom-left of the grid
while indices \verb{[1,ncol]} corresponds to the bottom-right of the grid.
The even rows are assumed to be on the \strong{left} of the ones on the odd rows
(for those in the same column in the matrix).
This matrix has a "pattern_hex" subclass which supports a special \code{print()} method.
}
\description{
\code{pattern_hex()} returns an integer matrix indicating where each
color (or other graphical element) should be drawn on a (horizontal) hex grid
for a specified hex pattern type and subtype.
\code{names_hex} lists the currently supported hex \code{type}s.
}
\details{
\describe{
\item{"hex"}{Attempts to use a uniform coloring if it exists.
For subtype \code{1L}, \code{2L}, and \code{3L} we use the "hex1" pattern.
For subtype \code{4L} we use the "hex2" pattern.
For subtype \code{7L} we use the "hex3" pattern.
Else a uniform coloring does not exist and we use the "hex_skew" pattern.}
\item{"hex1"}{Provides the 1-uniform colorings of a hexagonal tiling.  Only exists for \code{subtype} \code{1L}, \code{2L}, or \code{3L}.}
\item{"hex2"}{Provides the 2-uniform colorings of a hexagonal tiling.  Only exists for \code{subtype} \code{2L} or \code{4L}.}
\item{"hex3"}{Provides the 3-uniform colorings of a hexagonal tiling.  Only exists for \code{subtype} \code{2L} or \code{7L}.}
\item{"hex_skew"}{For the "hex_skew" \code{type} we cycle through \code{subtype} elements on the horizontal line and "main" diagonal line.
For some \code{subtype} numbers this may lead to noticeable color repeats on the "skew" diagonal line.
If \code{subtype} is strictly greater than \code{2L} then a hexagon should never touch another hexagon of the same color.}
}
}
\examples{
 # supported hex names
 print(names_hex)

 # 1-uniform 3-color
 hex_3color <- pattern_hex("hex1", 3L, nrow = 7L, ncol = 9L)
 print(hex_3color)

 # 2-uniform 4-color
 hex_4color <- pattern_hex("hex2", 4L, nrow = 7L, ncol = 9L)
 print(hex_4color)

}
\seealso{
\code{\link[=grid.pattern_regular_polygon]{grid.pattern_regular_polygon()}} for drawing to a graphics device
hexagons, triangles, circles, etc. in hexagon patterns.
The tiling vignette features several examples of regular polygon tiling using
this both the "hex" and "hex_circle" types \code{vignette("tiling", package = "gridpattern")}.
For more information on uniform colorings of a hexagonal tiling see
\url{https://en.wikipedia.org/wiki/Hexagonal_tiling#Uniform_colorings}.
}
\keyword{datasets}
