% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otgrid.R
\name{otgrid}
\alias{otgrid}
\title{Two-dimensional Grid with Mass}
\usage{
otgrid(
  mass,
  x = NULL,
  y = NULL,
  sorted = FALSE,
  normalize = FALSE,
  remove.zeros = FALSE
)
}
\arguments{
\item{mass}{matrix of non-negative weights.}

\item{x}{vector of support points of the first marginal.}

\item{y}{vector of support points of the second marginal.}

\item{sorted}{logical value specifying whether or not the support points are sorted.}

\item{normalize}{logical value specifying whether or not the total mass should be rescaled to 1.}

\item{remove.zeros}{logical value specifying whether or not marginals with no mass should be removed from the grid.}
}
\value{
object of class \code{"otgrid"}. It contains the following elements:
\tabular{ll}{
\code{x}     \tab vector of support points of the first marginal  \cr
\code{y}     \tab vector of support points of the second marginal \cr
\code{n}     \tab number of support points of the first marginal  \cr
\code{m}     \tab number of support points of the second marginal \cr
\code{mass}  \tab matrix of non-negative weights                  \cr
\code{total} \tab total mass
}

Also note that the functions \code{print} and \code{plot} are available for objects of class \code{"otgrid"}.
}
\description{
Create an object that represents a probability measure that is supported on a two-dimensional grid.
}
\details{
If \code{x} and \code{y} are not specified, then a equispaced unit grid is chosen.
}
\examples{
x <- otgrid(cbind(1:2, 0, 3:4), remove.zeros = TRUE)

print(x) # note that it's only 2 x 2 
plot(x)
}
\seealso{
plot \code{\link{plot.otgrid}}
}
