% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instrumental_forest.R
\name{instrumental_forest}
\alias{instrumental_forest}
\title{Intrumental forest}
\usage{
instrumental_forest(X, Y, W, Z, Y.hat = NULL, W.hat = NULL, Z.hat = NULL,
  sample.fraction = 0.5, mtry = NULL, num.trees = 2000,
  num.threads = NULL, min.node.size = NULL, honesty = TRUE,
  ci.group.size = 2, reduced.form.weight = 0, alpha = 0.05,
  imbalance.penalty = 0, stabilize.splits = TRUE, seed = NULL,
  clusters = NULL, samples_per_cluster = NULL)
}
\arguments{
\item{X}{The covariates used in the instrumental regression.}

\item{Y}{The outcome.}

\item{W}{The treatment assignment (may be binary or real).}

\item{Z}{The instrument (may be binary or real).}

\item{Y.hat}{Estimates of the expected responses E[Y | Xi], marginalizing
over treatment. If Y.hat = NULL, these are estimated using
a separate regression forest.}

\item{W.hat}{Estimates of the treatment propensities E[W | Xi]. If W.hat = NULL,
these are estimated using a separate regression forest.}

\item{Z.hat}{Estimates of the instrument propensities E[Z | Xi]. If Z.hat = NULL,
these are estimated using a separate regression forest.}

\item{sample.fraction}{Fraction of the data used to build each tree.
Note: If honesty is used, these subsamples will
further be cut in half.}

\item{mtry}{Number of variables tried for each split.}

\item{num.trees}{Number of trees grown in the forest. Note: Getting accurate
confidence intervals generally requires more trees than
getting accurate predictions.}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{min.node.size}{A target for the minimum number of observations in each tree leaf. Note that nodes
with size smaller than min.node.size can occur, as in the original randomForest package.}

\item{honesty}{Whether or not honest splitting (i.e., sub-sample splitting) should be used.}

\item{ci.group.size}{The forst will grow ci.group.size trees on each subsample.
In order to provide confidence intervals, ci.group.size must
be at least 2.}

\item{reduced.form.weight}{Whether splits should be regularized towards a naive
splitting criterion that ignores the instrument (and
instead emulates a causal forest).}

\item{alpha}{A tuning parameter that controls the maximum imbalance of a split.}

\item{imbalance.penalty}{A tuning parameter that controls how harshly imbalanced splits are penalized.}

\item{stabilize.splits}{Whether or not the instrument should be taken into account when
determining the imbalance of a split (experimental).}

\item{seed}{The seed for the C++ random number generator.}

\item{clusters}{Vector of integers or factors specifying which cluster each observation corresponds to.}

\item{samples_per_cluster}{If sampling by cluster, the number of observations to be sampled from
each cluster. Must be less than the size of the smallest cluster. If set to NULL
software will set this value to the size of the smallest cluster.}
}
\value{
A trained instrumental forest object.
}
\description{
Trains an instrumental forest that can be used to estimate
conditional local average treatment effects tau(X) identified
using instruments. Formally, the forest estimates
tau(X) = Cov[Y, Z | X = x] / Cov[W, Z | X = x].
Note that when the instrument Z and treatment assignment W
coincide, an instrumental forest is equivalent to a causal forest.
}
