% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{pinball}
\alias{pinball}
\title{Pinball function}
\usage{
pinball(holdout, forecast, level, loss = 1, na.rm = TRUE)
}
\arguments{
\item{holdout}{The vector or matrix of the holdout values.}

\item{forecast}{The forecast of prediction interval (should be the same length as the
holdout).}

\item{level}{The level of the prediction interval associated with the forecast.}

\item{loss}{The type of loss to use. The number which corresponds to L1, L2 etc.}

\item{na.rm}{Logical, defining whether to remove the NAs from the provided data or not.}
}
\value{
The function returns the scalar value.
}
\description{
The function returns the value from the pinball function for the specified level and
the type of loss
}
\examples{
# An example with mtcars data
ourModel <- alm(mpg~., mtcars[1:30,], distribution="dnorm")

# Produce predictions with the interval
ourForecast <- predict(ourModel, mtcars[-c(1:30),], interval="p")

# Pinball with the L1 (quantile value)
pinball(mtcars$mpg[-c(1:30)],ourForecast$upper,level=0.975,loss=1)
pinball(mtcars$mpg[-c(1:30)],ourForecast$lower,level=0.025,loss=1)

# Pinball with the L2 (expectile value)
pinball(mtcars$mpg[-c(1:30)],ourForecast$upper,level=0.975,loss=2)
pinball(mtcars$mpg[-c(1:30)],ourForecast$lower,level=0.025,loss=2)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
