% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alg_classes.R
\name{greed_cond}
\alias{greed_cond}
\title{Conditional model based hierarchical clustering}
\usage{
greed_cond(
  X,
  Y,
  K = 20,
  model = methods::new("mvmreg", N0 = ncol(Y) + 1),
  alg = methods::new("hybrid"),
  verbose = FALSE
)
}
\arguments{
\item{X}{design matrix}

\item{Y}{target variables}

\item{K}{Desired number of cluster}

\item{model}{a conditional generative model \code{\link{mvmreg-class}}}

\item{alg}{an optimization algorithm of class \code{\link{hybrid-class}} (default), \code{\link{multistarts-class}}, \code{\link{seed-class}} or \code{\link{genetic-class}}}

\item{verbose}{Boolean for verbose mode}
}
\value{
an \code{\link{icl_path-class}} object
}
\description{
Conditional model based hierarchical clustering
}
