% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Raster-class.R, R/array-class.R,
%   R/grec-internal.R, R/grec-main.R, R/list-class.R, R/matrix-class.R
\name{detectFronts.RasterLayer}
\alias{detectFronts.RasterLayer}
\alias{detectFronts.array}
\alias{detectFronts.default}
\alias{detectFronts}
\alias{detectFronts.list}
\alias{detectFronts.matrix}
\title{Apply gradient-based methodologies to environmental data}
\usage{
\method{detectFronts}{RasterLayer}(x, method = "BelkinOReilly2009",
  intermediate = FALSE, ...)

\method{detectFronts}{array}(x, method = "BelkinOReilly2009",
  intermediate = FALSE, ...)

\method{detectFronts}{default}(x, method = "BelkinOReilly2009",
  intermediate = FALSE, ...)

detectFronts(x, method = "BelkinOReilly2009", intermediate = FALSE, ...)

\method{detectFronts}{list}(x, method = "BelkinOReilly2009",
  intermediate = FALSE, ...)

\method{detectFronts}{matrix}(x, method = "BelkinOReilly2009",
  intermediate = FALSE, ...)
}
\arguments{
\item{x}{Main input of class \code{matrix}, \code{array}, XYZ \code{list} or \code{RasterLayer}. See 'Details.'}

\item{method}{\code{character} string indicating the method that will be used. See 'Details'.}

\item{intermediate}{\code{logical} indicating whether to get the intermediate matrices (\code{TRUE})
or just the final one (\code{FALSE}).}

\item{...}{Extra arguments that will depend on the selected method. See Details.}
}
\value{
The output will preserve the input class (\code{matrix}, \code{array}, \code{list} or \code{RasterLayer}).
}
\description{
This function takes a environmental map (as a numeric \code{matrix}, \code{array}, XYZ\code{list}
or \code{RasterLayer}) and allows the users to apply methodologies based on gradient-searching.
}
\details{
Version 1.2.x performs one method: Belkin & O'Reilly (2009), following 3 steps:
\enumerate{
\item Apply a Contextual Median Filter (CMF) for smoothing the original data.
\item Apply a convolution with sobel kernels horizontally (sobelH) and vertically (sobelV).
\item Extract gradients using the formula \eqn{sqrt(sobelH^2 + sobelV^2)}.
}

\code{x} could be given as a single numeric \code{matrix} from an environmental map. Othersiwe it also can be set
as a three-dimension XYZ \code{list}: 'x' (a vector of longitudes), 'y' (vector of latitudes) and
'z' as a matrix of dimensions \code{length(x$x)}x\code{xlength(x$y)}. You can also specify \code{x} as a
\code{RasterLayer} or \code{array} object. If \code{x} is an \code{array}, it must have 3 dimensions: lon, lat
and time. It is not required to specify the \code{dimnames}. The output will preserve all the attributes of input.

Users can change the methodology used for the calculation of gradients by \code{method}. By default it will be
the Belkin & O'Reilly (2009) at v1.2.x.

\code{...} allows the (advanced) users to modify some aspects of filter application. Depending on the selected methodology,
the available arguments will change. So, Belkin & O'Reilly (2009) brings out the following arguments to change:

\describe{
\item{\strong{inner_radius}}{\code{numeric}. Size (in pixels) of window for the first stage on CMF.}
\item{\strong{outer_radius}}{\code{numeric}. Size (in pixels) of window for the second stage on CMF.}
\item{\strong{times}}{\code{numeric}. How many times do you want to apply the CMF?}
\item{\strong{kernelValues}}{\code{numeric}. Vector with which are going to be used in convolution to identify Vertical
and Horizontal gradients. By default, it will be the typical Sobel kernels.}
}
}
\examples{
# Build an example data
# Load example data
data(sst)
exampleSSTData <- list(x = sst$longitude,
                       y = sst$latitude,
                       z = sst$sst[,,1])
# Simple application (over a XYZ list)
out <- detectFronts(x = exampleSSTData)
image(out, col = colPalette)
}
\references{
Belkin, I. M., & O'Reilly, J. E. (2009). An algorithm for oceanic front detection in chlorophyll
and SST satellite imagery. Journal of Marine Systems, 78(3), 319-326
(\url{http://dx.doi.org/10.1016/j.jmarsys.2008.11.018}).
}
