#' Render package citations
#'
#' @param Rmd.file Path to Rmarkdown file generated by [create_rmd()].
#' @param out.dir Directory to save the output document.
#' @param out.format Output format, either "html", docx" (Word), "pdf", or "md" (markdown).
#'
#' @return A document in the format specified by `out.format`.
#'
#' @noRd
#'

render_citations <- function(Rmd.file = NULL,
                             out.dir = NULL,
                             out.format = c("html", "docx", "pdf", "md")
                             ) {

  if (is.null(Rmd.file)) {
    stop("Please provide Rmd.file")
  }

  if (is.null(out.dir)) {
    stop("Please specify where to save the citation report, e.g. out.dir = getwd()")
  }

  out.format <- match.arg(out.format)

  if (out.format == "docx") output <- "word_document"
  if (out.format == "pdf") output <- "pdf_document"
  if (out.format == "html") output <- "html_document"
  if (out.format == "md") output <- "md_document"

  out.name <- gsub(pattern = ".Rmd", replacement = "", basename(Rmd.file))

  rmarkdown::render(
    input = Rmd.file,
    output_format = output,
    output_file = paste0(out.name, ".", out.format),
    output_dir = out.dir
  )

  out.file <- file.path(out.dir, paste0(out.name, ".", out.format))
  invisible(out.file)

}
