#' graphon : a Collection of Graphon Estimation Methods
#'
#' The \pkg{graphon} provides a not-so-comprehensive list of methods for estimating graphon,
#' a symmetric measurable function, from a single or multiple of observed networks.
#' It also contains several auxiliary functions for generating sample networks using
#' various network models and graphons.
#'
#'
#' @section What is Graphon?:
#' Graphon - graph function - is a symmetric measurable function \deqn{W:[0,1]^2->[0,1]} that arise
#' in studying exchangeable random graph models as well as sequence of dense graphs. In the language of
#' graph theory, it can be understood as a two-stage procedural network modeling that 1) each vertex/node in the graph
#' is assigned an independent random variable \eqn{u_j} from uniform distribution \eqn{U[0,1]}, and
#' 2) each edge \eqn{(i,j)} is randomly determined with probability \eqn{W(u_i,u_j)}. Due to such
#' procedural aspect, the term \emph{probability matrix} and \emph{graphon} will be interchangeably used
#' in further documentation.
#'
#'
#' @section Composition of the package:
#' The package mainly consists of two types of functions whose names start with \code{'est'}
#' and \code{'gmodel'} for estimation algorithms and graph models, respectively.
#'
#' The \code{'est'} family has 4 estimation methods at the current version,
#' \itemize{
#'   \item \code{\link{est.LG}} for empirical degree sorting in stochastic blockmodel.
#'   \item \code{\link{est.SBA}} for stochastic blockmodel approximation.
#'   \item \code{\link{est.USVT}} for universal singular value thresholding.
#'   \item \code{\link{est.nbdsmooth}} for neighborhood smoothing.
#' }
#'
#' Also, the current release has following graph models implemented,
#' \itemize{
#'   \item \code{\link{gmodel.P}} generates a binary graph given an arbitrary probability matrix.
#'   \item \code{\link{gmodel.ER}} is an implementation of Erdos-Renyi random graph models.
#'   \item \code{\link{gmodel.block}} is used to generate networks with block structure.
#'   \item \code{\link{gmodel.preset}} has 10 exemplary graphon models for simulation.
#'  }
#'
#' @section Acknowledgements:
#' Some of the codes are translated from a \href{https://github.com/airoldilab/}{MATLAB package} developed by
#' \href{https://engineering.purdue.edu/ChanGroup/stanleychan.html}{Stanley Chan} (Purdue) and
#' \href{http://www.people.fas.harvard.edu/~airoldi/}{Edoardo Airoldi} (Harvard).
#'
#' @author Kisung You
#' @docType package
#' @name graphon
#' @importFrom graphics image par
#' @importFrom stats quantile rbinom runif
#' @references Erdos, P. and Renyi, A. (1959) \emph{On Random Graphs I}. Publications
#' Mathematicae, Vol.6:290-297.
#' @references Gilbert, E.N. (1959) \emph{Random Graphs}. Annals of Mathematical
#' Statistics, Vol.30, No.4:1141-1144.
#' @references Channarond, A., Daudin, J., and Robin, S. (2012) \emph{Classification
#' and estimation in the SBM based on empirical degrees}. Electronic Journal
#' of Statistics, Vol.6:2574-2601.
#' @references Airoldi, E.M., Costa, T.B., and Chan, S.H. (2013) \emph{Stochastic
#' blockmodel approximation of a graphon: Theory and consistent estimation}. Advances
#' in Neural Information Processing Systems,  692-700.
#' @references Chan, S.H. and Airoldi, E.M. (2014) \emph{A consistent histogram
#' estimator for exchangeable graph models}. Journal of Machine Learning Research Workshop
#' and Conference Proceedings, Vol.32, No.1:208-216.
#' @references Chatterjee, S. (2015) \emph{Matrix estimation by universal singular
#' value thresholding}. The Annals of Statistics, Vol.43, No.1:177-214.
#' @references Zhang, Y., Levina, E., and Zhu, J. (2015) \emph{Estimating neighborhood edge
#' probabilities by neighborhood smoothing}. Arxiv:1509.08588
#' @references Mukherjee, S.S., Sarkar, P., and Lin, L. (2016) \emph{On estimating a
#' mixture of graphons}. Arxiv:1606.02401
NULL



