% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_completions_main.R
\name{complete_Gamma_decomposable}
\alias{complete_Gamma_decomposable}
\title{Completion of decomposable Gamma matrices}
\usage{
complete_Gamma_decomposable(Gamma, graph = NULL)
}
\arguments{
\item{Gamma}{A variogram matrix that is specified on the edges of \code{graph}
and the diagonals. All other entries are ignored (if \code{graph} is specified),
or should be \code{NA} to indicate non-edges in \code{graph}.}

\item{graph}{\code{NULL} or a decomposable [\code{igraph::graph}] object. If \code{NULL}, the
structure of \code{NA} entries in \code{Gamma} is used instead.}
}
\value{
A complete variogram matrix that agrees with \code{Gamma} on the entries
corresponding to edges in \code{graph} and the diagonals.
The corresponding \eTheta matrix produced by \code{\link[=Gamma2Theta]{Gamma2Theta()}} has zeros
in the remaining entries.
}
\description{
Given a decomposable \code{graph} and incomplete variogram matrix \code{Gamma},
returns the full \code{Gamma} matrix implied by the conditional independencies.
}
\seealso{
Other matrix completion related topics:
\code{\link{complete_Gamma_general_demo}()},
\code{\link{complete_Gamma_general_split}()},
\code{\link{complete_Gamma_general}()},
\code{\link{complete_Gamma}()}
}
\concept{matrixCompletions}
