% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_functions.R
\name{rmpareto}
\alias{rmpareto}
\title{Sampling of a multivariate Pareto distribution}
\usage{
rmpareto(n, model = c("HR", "logistic", "neglogistic", "dirichlet"), d, par)
}
\arguments{
\item{n}{Number of simulations.}

\item{model}{The parametric model type; one of:
\itemize{
\item \code{HR} (default),
\item \code{logistic},
\item \code{neglogistic},
\item \code{dirichlet}.
}}

\item{d}{Dimension of the multivariate Pareto
distribution.}

\item{par}{Respective parameter for the given \code{model}, that is,
\itemize{
\item \eGamma, numeric \dxd variogram matrix, if \code{model = HR}.
\item \eqn{\theta \in (0, 1)}{0 < \theta < 1}, if \code{model = logistic}.
\item \eqn{\theta > 0}, if \code{model = neglogistic}.
\item \eqn{\alpha}, numeric vector of size \code{d} with positive entries, if \code{model = dirichlet}.
}}
}
\value{
Numeric \nxd matrix of simulations of the
multivariate Pareto distribution.
}
\description{
Simulates exact samples of a multivariate Pareto distribution.
}
\details{
The simulation follows the algorithm in \insertCite{eng2019;textual}{graphicalExtremes}.
For details on the parameters of the Huesler--Reiss, logistic
and negative logistic distributions see \insertCite{dom2016;textual}{graphicalExtremes}, and for the Dirichlet
distribution see \insertCite{coles1991modelling;textual}{graphicalExtremes}.
}
\examples{
## A 4-dimensional HR distribution
n <- 10
d <- 4
G <- cbind(
  c(0, 1.5, 1.5, 2),
  c(1.5, 0, 2, 1.5),
  c(1.5, 2, 0, 1.5),
  c(2, 1.5, 1.5, 0)
)

rmpareto(n, "HR", d = d, par = G)

## A 3-dimensional logistic distribution
n <- 10
d <- 3
theta <- .6
rmpareto(n, "logistic", d, par = theta)

## A 5-dimensional negative logistic distribution
n <- 10
d <- 5
theta <- 1.5
rmpareto(n, "neglogistic", d, par = theta)

## A 4-dimensional Dirichlet distribution
n <- 10
d <- 4
alpha <- c(.8, 1, .5, 2)
rmpareto(n, "dirichlet", d, par = alpha)
}
\references{
\insertAllCited{}
}
