% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{Sigma2Gamma}
\alias{Sigma2Gamma}
\title{Transformation of \eSigma and \eSigmaK matrix to \eGamma matrix}
\usage{
Sigma2Gamma(Sigma, k = NULL, full = FALSE)
}
\arguments{
\item{Sigma}{Numeric \d1xd1 covariance matrix \eSigmaK
from the definition of a Huesler--Reiss distribution.
Numeric \dxd covariance matrix if \code{full = TRUE}, see \code{full} parameter.}

\item{k}{Integer between \code{1} (the default value) and \code{d}.
Indicates which matrix \eSigmaK is given as \code{S}.}

\item{full}{Logical. If true, then the \code{k}th row and column in \eSigmaK
are included and the function returns a \dxd matrix.
By default, \code{full = FALSE}.}
}
\value{
Numeric \dxd \eGamma matrix.
}
\description{
Transforms the \eSigmaK matrix from the definition of a
Huesler--Reiss distribution to the corresponding \eGamma matrix.
}
\details{
For any \code{k} from \code{1} to \code{d},
the \eSigmaK matrix of size \d1xd1
in the definition of a
Huesler--Reiss distribution can be transformed into a the
corresponding \dxd \eGamma matrix.
If \code{full = TRUE}, then \eSigmaK must be a \dxd
matrix with \code{k}th row and column
containing zeros. For details see \insertCite{eng2019;textual}{graphicalExtremes}.
This is the inverse of function of \code{\link[=Gamma2Sigma]{Gamma2Sigma()}}.
}
\examples{
Sigma1 <- rbind(
  c(1.5, 0.5, 1),
  c(0.5, 1.5, 1),
  c(1, 1, 2)
)
Sigma2Gamma(Sigma1, k = 1, full = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
Other MatrixTransformations: 
\code{\link{Gamma2Sigma}()},
\code{\link{Gamma2Theta}()},
\code{\link{Gamma2graph}()},
\code{\link{Theta2Gamma}()}
}
\concept{MatrixTransformations}
