% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_graph_thr.R
\name{gen_graph_thr}
\alias{gen_graph_thr}
\title{Create a graph of genetic differentiation
using a link weight threshold}
\usage{
gen_graph_thr(mat_w, mat_thr = NULL, thr, mode = "larger")
}
\arguments{
\item{mat_w}{A symmetric (pairwise) \code{matrix} or a \code{dist} object
whose elements will be the links' weights}

\item{mat_thr}{(optional) A symmetric (pairwise) distance \code{matrix}
or a \code{dist} object whose values will be used for the pruning based
on the threshold value.}

\item{thr}{The threshold value (logically between min(mat_thr)
and max(mat_thr))(integer or numeric)}

\item{mode}{\itemize{
\item{If 'mode = 'larger'' (default), all the links whose weight is larger
than 'thr' are removed.}
\item{If 'mode = 'lower'', all the links whose weight is lower
than 'thr' are removed.}
}}
}
\value{
A graph object of class \code{igraph}
}
\description{
The function allows to construct a genetic graph whose
links' weights are larger or lower than a specific threshold
}
\details{
If 'mat_thr' is not defined, 'mat_w' is used for the pruning.
Matrices 'mat_w' and 'mat_thr' must have the same dimensions and the
same rows' and columns' names.
Values in 'mat_thr' matrix must be positive. Negative values from
'mat_w' are transformed into zeros.
The function works only for undirected graphs.
If dist objects are specified, it is assumed that colnames and
row.names of mat_w and mat_thr refer to the same populations/locations.
}
\examples{
mat_w <- mat_gen_dist(x = data_ex_genind, dist = 'DPS')
suppressWarnings(mat_thr <- mat_geo_dist(pts_pop_ex,
                 ID = "ID",
                 x = "x",
                y = "y"))
mat_thr <- mat_thr[row.names(mat_w), colnames(mat_w)]
graph <- gen_graph_thr(mat_w, mat_thr, thr = 6000, mode = "larger")
}
\author{
P. Savary
}
