% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphab_metric.R
\name{graphab_metric}
\alias{graphab_metric}
\title{Compute connectivity metrics from a graph in the Graphab project}
\usage{
graphab_metric(
  proj_name,
  graph,
  metric,
  dist = NULL,
  prob = 0.05,
  beta = 1,
  cost_conv = FALSE,
  return_val = TRUE,
  proj_path = NULL,
  alloc_ram = NULL
)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml is.}

\item{graph}{A character string indicating the name of the graph on which
the metric is computed. This graph has been created with Graphab
or using \code{\link{graphab_graph}} function and is associated
with a link set. Only the links present in the graph and their corresponding
weights will be used in the computation, together with patch areas.}

\item{metric}{A character string indicating the metric which will be computed
on the graph. This metric can be:\itemize{
\item{A global metric:\itemize{
\item{Probability of Connectivity (\code{metric = 'PC'}): Sum of products of
area of all pairs of patches weighted by their interaction probability,
divided by the square of the area of the study zone.
This ratio is the equivalent to the probability that two points randomly
placed in the study area are connected.}
\item{Integral Index of Connectivity (\code{metric = 'IIC'}): For the
entire graph: product of patch areas divided by the number of links
between them, the sum is divided by the square of the area of the study
zone. IIC is built like the PC index but using the inverse of a topological
distance rather than a negative exponential function of the distance
based on the link weight.}
}}
\item{A local metric:\itemize{
\item{Flux (\code{metric = 'F'}): For the focal patch i : sum of area
of patches other than i and weighted according to their minimum distance
to the focal patch through the graph. This sum is an indicator of the
potential dispersion from the patch i or, conversely to the patch i}
\item{Betweenness Centrality index (\code{metric = 'BC'}): Sum of the
shortest paths through the focal patch i, each path is weighted by the
product of the areas of the patches connected and of their interaction
probability. All possible paths between every pair of patches is
considered in this computation.}
\item{Interaction Flux (\code{metric = 'IF'}): Sum of products of the focal
patch area with all the other patches, weighted by their interaction
probability.}
\item{Degree (\code{metric = 'Dg'}): Number of edges connected to the
node i i.e. number of patches connected directly to the patch i.}
\item{Closeness Centrality index (\code{metric = 'CCe'}): Mean distance
from the patch i to all other patches of its component k.}
\item{Current Flux (\code{metric = 'CF'}): Sum of currents passing through
the patch i. \eqn{c_{i}^{j}} represents the current through the patch i when
currents are sent from all patches (except j) to the patch j.
The patch j is connected to the ground.}
}}
\item{A delta metric:\itemize{
\item{delta Probability of Connectivity (\code{metric = 'dPC'}): Rate of
variation between the value of PC index and the value of PC' corresponding
to the removal of the patch i. The value of \code{dPC} is decomposed
into three parts:\itemize{
\item{\eqn{dPC_{area}} is the variation induced by the area lost after removal;}
\item{\eqn{dPC_{flux}} is the variation induced by the loss of interaction
between the patch i and other patches;}
\item{\eqn{dPC_{connector}} is the variation induced by the modification of
paths connecting other patches and initially routed through i.}
}
}}
}}
For most metrics, the interaction probability is computed for each pair of
patches from the path that minimizes the distance d (or the cost) between
them. It then maximizes \eqn{{e}^{-\alpha d_{ij}}} for patches i and j.
To use patch capacity values different from the patch area, please use
directly Graphab software.}

\item{dist}{A numeric or integer value specifying the distance at which
dispersal probability is equal to \code{prob}. This argument is mandatory
for weighted metrics (PC, F, IF, BC, dPC, CCe, CF) but not used for others.
It is used to set \eqn{\alpha} for computing dispersal probabilities associated
with all inter-patch distances such that dispersal probability between
patches i and j is \eqn{p_{ij}= e^{-\alpha d_{ij}}}.}

\item{prob}{A numeric or integer value specifying the dispersal probability
at distance \code{dist}. By default, \code{code=0.05}. It is used to set
\eqn{\alpha} (see param \code{dist} above).}

\item{beta}{A numeric or integer value between 0 and 1 specifying the
exponent associated with patch areas in the computation of metrics
weighted by patch area. By default, \code{beta=1}. When \code{beta=0}, patch
areas do not have any influence in the computation.}

\item{cost_conv}{FALSE (default) or TRUE. Logical indicating whether numeric
\code{dist} values are converted from cost-distance into Euclidean distance
using a log-log linear regression. See also \code{\link{convert_cd}}
function.}

\item{return_val}{Logical (default = TRUE) indicating whether metric values
are returned in R (TRUE) or only stored in the patch attribute layer (FALSE)}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}

\item{alloc_ram}{(optional, default = NULL) Integer or numeric value
indicating RAM gigabytes allocated to the java process. Increasing this
value can speed up the computations. Too large values may not be compatible
with your machine settings.}
}
\value{
If \code{return_val=TRUE}, the function returns a \code{data.frame}
with the computed metric values and the corresponding patch ID when the
metric is local or delta metric, or the numeric value of the global metric.
}
\description{
The function computes connectivity metrics on a graph from a
link set in a Graphab project
}
\details{
The metrics are described in Graphab 2.6 manual:
\url{https://sourcesup.renater.fr/www/graphab/download/manual-2.6-en.pdf}
Graphab software makes possible the computation of other metrics.
}
\examples{
\dontrun{
graphab_metric(proj_name = "grphb_ex",
               graph = "graph",
               metric = "PC",
               dist = 1000,
               prob = 0.05,
               beta = 1)
}
}
\author{
P. Savary
}
