% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_great_circle.R
\name{dist_gc_vicenty}
\alias{dist_gc_vicenty}
\title{Calculate the Great-Circle distance between two points using the
Vincenty inverse formula for ellipsoids (vicenty)}
\usage{
dist_gc_vicenty(long1, lat1, long2, lat2)
}
\arguments{
\item{long1}{Point 1 longitude in radians}

\item{lat1}{Point 1 latitude in radians}

\item{long2}{Point 2 longitude in radians}

\item{lat2}{Point 2 latitude in radians}
}
\value{
The distance between points 1 and 2 in meters
}
\description{
The function calculates the Great-Circle distance between two
points specified by radian latitude/longitude using the
Vincenty inverse formula for ellipsoids (vicenty)
}
\examples{
dist_gc_vicenty(long1 = -73.99420, lat1 = 40.75170,
            long2 = -87.63940, lat2 = 41.87440)
}
\author{
P. Savary
}
\keyword{internal}
