% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_w_hist.R
\name{plot_w_hist}
\alias{plot_w_hist}
\title{Plot histograms of links weight}
\usage{
plot_w_hist(graph, fill = "#396D35")
}
\arguments{
\item{graph}{A graph object of class \code{igraph} whose links are weighted}

\item{fill}{A character string indicating the color used to fill
the bars (default: "#396D35"). It must be a hexadecimal color code or
a color used by default in R.}
}
\value{
A ggplot2 object to plot
}
\description{
The function enables to plot histogram to visualize the
distribution of the links' weights
}
\examples{
data(data_simul_genind)
mat_w <- mat_gen_dist(data_simul_genind, dist = "DPS")
gp <- gen_graph_topo(mat_w = mat_w, topo = "gabriel")
hist <- plot_w_hist(gp)
}
\author{
P. Savary
}
