% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grantham_distance.R
\name{grantham_distance_exact}
\alias{grantham_distance_exact}
\title{Grantham's distance (exact)}
\source{
\doi{10.1126/science.185.4154.862}.
}
\usage{
grantham_distance_exact(
  x,
  y,
  alpha = 1.833,
  beta = 0.1018,
  gamma = 0.000399,
  rho = 50.723
)
}
\arguments{
\item{x}{A character vector of amino acid three-letter codes, e.g. \code{"Ala"}
(Alanine).}

\item{y}{A character vector of amino acid three-letter codes.}

\item{alpha}{The constant \eqn{\alpha} in the equation of Grantham's
paper, in page 863.}

\item{beta}{The constant \eqn{\beta} in the equation of Grantham's
paper, in page 863.}

\item{gamma}{The constant \eqn{\gamma} in the equation of Grantham's
paper, in page 863.}

\item{rho}{Grantham's distances reported in Table 2, Science (1974).
185(4154): 862--4 by R. Grantham, are scaled by a factor (here named
\eqn{\rho}) such that the mean value of all distances are 100. The \code{rho}
parameter allows this factor \eqn{\rho} to be changed. By default
\eqn{\rho=50.723}, the same value used by Grantham. This value is
originally mentioned in the caption of Table 2 of the aforementioned paper.}
}
\value{
A \link[tibble:tibble-package]{tibble} of Grantham's distances for each
amino acid pair.
}
\description{
This function calculates the Grantham's distance for pairs of amino acids. It
uses the values for the amino acid properties as published in Table 1 of
Science (1974). 185(4154): 862--4 by R. Grantham.
}
\details{
Contrary to Grantham's distances presented in Table 2 of Grantham's paper, the
distances returned by this function are calculated anew starting from the
amino acid properties (composition, polarity and molecular volume). No
rounding to nearest integer is performed.
}
\examples{
grantham_distance_exact(c("Ser", "Ser"), c("Pro", "Trp"))

}
\seealso{
\code{\link[=grantham_equation]{grantham_equation()}}
}
\keyword{internal}
