% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_befafter_box.R
\name{plot_befafter_box}
\alias{plot_befafter_box}
\title{Before-after style graph with a boxplot}
\usage{
plot_befafter_box(
  data,
  xcol,
  ycol,
  match,
  facet,
  PlotShapes = FALSE,
  symsize = 3,
  s_alpha = 0.8,
  b_alpha = 1,
  bwid = 0.4,
  jitter = 0.1,
  TextXAngle = 0,
  LogYTrans,
  LogYBreaks = waiver(),
  LogYLabels = waiver(),
  LogYLimits = NULL,
  facet_scales = "fixed",
  fontsize = 20,
  symthick,
  bthick,
  lthick,
  ColPal = c("okabe_ito", "all_grafify", "bright", "contrast", "dark", "fishy", "kelly",
    "light", "muted", "pale", "r4", "safe", "vibrant"),
  ColSeq = TRUE,
  ColRev = FALSE,
  SingleColour = "NULL",
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column (without quotes) containing the categorical variable to be plotted on the X axis.}

\item{ycol}{name of the column (without quotes) with the quantitative variable to plot on the Y axis.}

\item{match}{name of the column (without quotes) with the grouping variable to pass on to \code{\link[ggplot2]{geom_line}}.}

\item{facet}{add another variable (without quotes) from the data table to create faceted graphs using \code{\link[ggplot2]{facet_wrap}}.}

\item{PlotShapes}{logical TRUE or FALSE (default = FALSE) if the shape of the symbol is to be mapped to the \code{match} variable. Note that only 25 shapes allowed.}

\item{symsize}{size of symbols, default set to 3.}

\item{s_alpha}{fractional opacity of symbols, default set to 0.8 (i.e., 80\% opacity).}

\item{b_alpha}{fractional opacity of boxes, default set to 1.}

\item{bwid}{width of boxplots; default 0.4.}

\item{jitter}{extent of jitter (scatter) of symbols, default is 0.1. Increase to reduce symbol overlap, set to 0 for aligned symbols.}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{LogYTrans}{transform Y axis into "log10" or "log2" (in quotes).}

\item{LogYBreaks}{argument for \code{\link[ggplot2]{scale_y_continuous}} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLabels}{argument for \code{\link[ggplot2]{scale_y_continuous}} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{facet_scales}{whether or not to fix scales on X & Y axes for all facet facet graphs. Can be \code{fixed} (default), \code{free}, \code{free_y} or \code{free_x} (for Y and X axis one at a time, respectively).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{\link[ggplot2]{theme_classic}}, default set to size 20.}

\item{symthick}{size (in 'pt' units) of outline of symbol lines (\code{stroke}), default = \code{fontsize}/22.}

\item{bthick}{thickness (in 'pt' units) of boxes; default = \code{(fontsize)/22}.}

\item{lthick}{thickness (in 'pt' units) of lines; default = \code{(fontsize/1.2)/22}.}

\item{ColPal}{grafify colour palette to apply (in quotes), default "okabe_ito"; see \code{\link{graf_palettes}} for available palettes.}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour within the selected palette, default F (FALSE); can be set to T (TRUE).}

\item{SingleColour}{a colour hexcode (starting with #, e.g., "#E69F00"), a number between 1-154, or names of colours from \code{grafify} or base R palettes to fill along X-axis aesthetic. Accepts any colour other than "black"; use \code{grey_lin11}, which is almost black.}

\item{...}{any additional arguments to pass to \code{\link[ggplot2]{geom_line}},  \code{\link[ggplot2]{geom_point}}, or \code{\link[ggplot2]{facet_wrap}}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
One of 3 related functions to plot matching data joined by lines. The variable containing information for matching (e.g. matched subjects or experiments etc.) is passed to the \code{match} argument.
\enumerate{
\item \code{\link{plot_befafter_colours}} or \code{\link{plot_befafter_colors}},
\item \code{\link{plot_befafter_shapes}}
\item \code{\link{plot_befafter_box}}
}
}
\details{
In \code{plot_befafter_colours}/\code{plot_befafter_colors} and \code{plot_befafter_shapes} setting \code{Boxplot = TRUE} will also plot a box and whiskers plot.

Note that only 25 shapes are available, and there will be errors with \code{\link{plot_befafter_shapes}} when there are fewer than 25 matched observations; instead use \code{\link{plot_befafter_colours}} instead.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

To plot a graph with a single colour along the X axis variable, use the \code{SingleColour} argument.

The resulting \code{ggplot2} graph can take additional geometries or other layers.
}
\examples{
plot_befafter_box(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
match = Subject)

#with PlotShapes = TRUE
plot_befafter_box(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
match = Subject, PlotShapes = TRUE)
}
