% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_grafify_c.R
\name{scale_colour_grafify_c}
\alias{scale_colour_grafify_c}
\title{Scale_colour continuous scheme}
\usage{
scale_colour_grafify_c(reverse = FALSE, ...)
}
\arguments{
\item{reverse}{Whether the colour order should be reversed.}

\item{...}{Additional parameters for \code{scale_fill} or \code{scale_colour}.}
}
\value{
ggplot scale_fill function for discrete colours.
}
\description{
\code{grafify} internally includes colour-blind compatible schemes for fill and colour/color aesthetics.
Note that this scheme is \strong{only} for continuous variables and has one palette (\code{yellow_conti}) \href{http://personal.sron.nl/~pault/#sec:sequential}{modified from} the YlOrBr scheme from RColorBrewer.
}
\details{
Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
}
\examples{
#basic usage on mtcars data with x and y quantitative axes
ggplot(mtcars, aes(x = mpg, y = disp))+
geom_point(aes(colour = disp), size = 3)+
scale_colour_grafify_c()

}
