% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_opencl.R
\name{setup_opencl}
\alias{setup_opencl}
\title{Setup OpenCL Arguments}
\usage{
setup_opencl(objects, intents, queues, kernel_maps = NULL)
}
\arguments{
\item{objects}{character vector of gpuR objects to be passed}

\item{intents}{character vector specifying 'intent' of gpuR objects.
options include \code{"IN"},\code{"OUT"},\code{"INOUT"}}

\item{queues}{list of character vectors reflecting equal length to \code{"objects"} 
where each element reflects a kernel function defined in an OpenCL kernel file.}

\item{kernel_maps}{The corresponding arguments names in the provided OpenCL kernel
corresponds to the gpuR objects passed and contains a character vector of
which kernels the object will be enqueued.}
}
\description{
Generates a \code{data.frame} of argument definitions
for use in \code{\link{custom_opencl}}
}
