% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-gpuMatrix.R, R/methods-gpuVector.R, R/methods-vclMatrix.R, R/methods-vclVector.R
\docType{methods}
\name{log,gpuMatrix-method}
\alias{log,gpuMatrix-method}
\alias{log,gpuVector-method}
\alias{log,vclMatrix-method}
\alias{log,vclVector-method}
\alias{log-gpuR-method}
\title{gpuR Logarithms and Exponentials}
\usage{
\S4method{log}{gpuMatrix}(x, base = NULL)

\S4method{log}{gpuVector}(x, base = NULL)

\S4method{log}{vclMatrix}(x, base = NULL)

\S4method{log}{vclVector}(x, base = NULL)
}
\arguments{
\item{x}{A gpuR object}

\item{base}{A positive number (complex not currently supported by OpenCL):
the base with respect to which logarithms are computed.  Defaults to the
natural log.}
}
\value{
A gpuR object of the same class as \code{x}
}
\description{
\code{log} computes logarithms, by default natural logarithms 
and \code{log10} computes common (i.e. base 10) logarithms.  The general form
\code{log(x, base)} computes logarithms with base \code{base}.

\code{exp} computes the exponential function.
}

