% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signing.R
\name{gpg_sign}
\alias{gpg_sign}
\alias{gpg_verify}
\alias{gpg}
\title{PGP Signatures}
\usage{
gpg_verify(signature, data = NULL, error = TRUE)

gpg_sign(data, signer = NULL, mode = c("detach", "normal", "clear"))
}
\arguments{
\item{signature}{path or raw vector for the gpg signature (contains the \code{PGP SIGNATURE} block)}

\item{data}{path or raw vector with data to sign or verify. In \code{gpg_verify} this
should be \code{NULL} if \code{signature} is not detached (i.e. \code{clear} or \code{normal} signature)}

\item{error}{raise an error if verification fails because you do not have the
signer public key in your keyring.}

\item{signer}{(optional) vector with key ID's to use for signing. If \code{NULL}, GPG tries
the user default private key.}

\item{mode}{use \code{normal} to create a full OpenPGP message containing both data and
signature or \code{clear} append the signature to the clear-text data (for email messages).
Default \code{detach} only returns the signature itself.}
}
\description{
Utilities to create and verify PGP signatures.
}
\examples{
\donttest{
# This requires you have the Debian master key in your keyring
msg <- tempfile()
sig <- tempfile()
download.file("http://http.us.debian.org/debian/dists/jessie/Release", msg)
download.file("http://http.us.debian.org/debian/dists/jessie/Release.gpg", sig)
gpg_verify(sig, msg, error = FALSE)
}
}
\seealso{
Other gpg: 
\code{\link{gpg_encrypt}()},
\code{\link{gpg_keygen}()},
\code{\link{gpg_keys}}
}
\concept{gpg}
