% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{set_optim_params.GPModel}
\alias{set_optim_params.GPModel}
\title{Set parameters for estimation of the covariance parameters}
\usage{
\method{set_optim_params}{GPModel}(gp_model, params = list())
}
\arguments{
\item{gp_model}{A \code{GPModel}}

\item{params}{A \code{list} with parameters for the estimation / optimization
 \itemize{
    \item{optimizer_cov: \code{string} (default = "lbfgs" for linear mixed effects models and "gradient_descent" for the GPBoost algorithm). 
    Optimizer used for estimating covariance parameters. 
    Options: "gradient_descent", "lbfgs", "fisher_scoring", "nelder_mead", "adam".
    If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'optimizer_cov' is also used for those }
    \item{optimizer_coef: \code{string} (default = "wls" for Gaussian likelihoods and "gradient_descent" for other likelihoods). 
    Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent", "lbfgs", "wls", "nelder_mead", "adam". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance parameters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    If 'optimizer_cov' is set to "nelder_mead", "lbfgs", or "adam", 
    'optimizer_coef' is automatically also set to the same value.}
    \item{maxit: \code{integer} (default = 1000). 
    Maximal number of iterations for optimization algorithm }
    \item{delta_rel_conv: \code{numeric} (default = 1E-6 except for "nelder_mead" for which the default is 1E-8). 
    Convergence tolerance. The algorithm stops if the relative change 
    in either the (approximate) log-likelihood or the parameters is below this value. 
    For "adam", the L2 norm of the gradient is used instead of the relative change in the log-likelihood. 
    If < 0, internal default values are used }
    \item{convergence_criterion: \code{string} (default = "relative_change_in_log_likelihood"). 
    The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" or "relative_change_in_parameters" }
    \item{init_coef: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for the regression coefficients (if there are any, can be NULL) }
    \item{init_cov_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). The order it the same as the order 
    of the parameters in the summary function: first is the error variance 
    (only for "gaussian" likelihood), next follow the variances of the 
    grouped random effects (if there are any, in the order provided in 'group_data'), 
    and then follow the marginal variance and the range of the Gaussian process. 
    If there are multiple Gaussian processes, then the variances and ranges follow alternatingly.
    If 'init_cov_pars = NULL', an internal choice is used that depends on the 
    likelihood and the random effects type and covariance function. 
    If you select the option 'trace = TRUE' in the 'params' argument, 
    you will see the first initial covariance parameters in iteration 0. }
    \item{lr_coef: \code{numeric} (default = 0.1). 
    Learning rate for fixed effect regression coefficients if gradient descent is used }
    \item{lr_cov: \code{numeric} (default = 0.1 for "gradient_descent" and 1. for "fisher_scoring"). 
    Initial learning rate for covariance parameters if "gradient_descent" or "fisher_scoring" is used. 
    If lr_cov < 0, internal default values are used.
    If there are additional auxiliary parameters for non-Gaussian likelihoods, 
    'lr_cov' is also used for those}
    \item{use_nesterov_acc: \code{boolean} (default = TRUE). 
    If TRUE Nesterov acceleration is used.
    This is used only for gradient descent }
    \item{acc_rate_coef: \code{numeric} (default = 0.5). 
    Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration }
    \item{acc_rate_cov: \code{numeric} (default = 0.5). 
    Acceleration rate for covariance parameters for Nesterov acceleration }
    \item{momentum_offset: \code{integer} (Default = 2)}. 
    Number of iterations for which no momentum is applied in the beginning.
    \item{trace: \code{boolean} (default = FALSE). 
    If TRUE, information on the progress of the parameter
    optimization is printed}
    \item{std_dev: \code{boolean} (default = TRUE). 
    If TRUE, approximate standard deviations are calculated for the covariance and linear regression parameters 
    (= square root of diagonal of the inverse Fisher information for Gaussian likelihoods and 
    square root of diagonal of a numerically approximated inverse Hessian for non-Gaussian likelihoods) }
    \item{init_aux_pars: \code{vector} with \code{numeric} elements (default = NULL). 
    Initial values for additional parameters for non-Gaussian likelihoods 
    (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{estimate_aux_pars: \code{boolean} (default = TRUE). 
    If TRUE, additional parameters for non-Gaussian likelihoods 
    are also estimated (e.g., shape parameter of a gamma or negative_binomial likelihood) }
    \item{cg_max_num_it: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithms }
    \item{cg_max_num_it_tridiag: \code{integer} (default = 1000). 
    Maximal number of iterations for conjugate gradient algorithm 
    when being run as Lanczos algorithm for tridiagonalization }
    \item{cg_delta_conv: \code{numeric} (default = 1E-2).
    Tolerance level for L2 norm of residuals for checking convergence 
    in conjugate gradient algorithm when being used for parameter estimation }
    \item{num_rand_vec_trace: \code{integer} (default = 50). 
    Number of random vectors (e.g., Rademacher) for stochastic approximation of the trace of a matrix }
    \item{reuse_rand_vec_trace: \code{boolean} (default = TRUE). 
    If true, random vectors (e.g., Rademacher) for stochastic approximations 
    of the trace of a matrix are sampled only once at the beginning of 
    the parameter estimation and reused in later trace approximations.
    Otherwise they are sampled every time a trace is calculated }
    \item{seed_rand_vec_trace: \code{integer} (default = 1). 
    Seed number to generate random vectors (e.g., Rademacher) }
    \item{piv_chol_rank: \code{integer} (default = 50). 
    Rank of the pivoted Cholesky decomposition used as 
    preconditioner in conjugate gradient algorithms }
    \item{cg_preconditioner_type: \code{string}.
    Type of preconditioner used for conjugate gradient algorithms.
    \itemize{
      \item Options for non-Gaussian likelihoods and gp_approx = "vecchia": 
        \itemize{
          \item{"piv_chol_on_Sigma" (= default): (Lk * Lk^T + W^-1) as preconditioner for inverting (B^-1 * D * B^-T + W^-1), 
      where Lk is a low-rank pivoted Cholesky approximation for Sigma and B^-1 * D * B^-T approx= Sigma }
          \item{"Sigma_inv_plus_BtWB": (B^T * (D^-1 + W) * B) as preconditioner for inverting (B^T * D^-1 * B + W), 
      where B^T * D^-1 * B approx= Sigma^-1 }
      }
      \item Options for likelihood = "gaussian" and gp_approx = "full_scale_tapering": 
        \itemize{
          \item{"predictive_process_plus_diagonal" (= default): predictive process preconditiioner }
          \item{"none": no preconditioner }
      }
    }
   }
}}
}
\value{
A \code{GPModel}
}
\description{
Set parameters for optimization of the covariance parameters of a \code{GPModel}
}
\examples{
\donttest{
data(GPBoost_data, package = "gpboost")
gp_model <- GPModel(group_data = group_data, likelihood="gaussian")
set_optim_params(gp_model, params=list(optimizer_cov="nelder_mead"))
}
}
\author{
Fabio Sigrist
}
