% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_delete.R
\name{range_delete}
\alias{range_delete}
\title{Delete cells}
\usage{
range_delete(ss, sheet = NULL, range, shift = NULL)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to delete, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number. Ignored if the sheet is specified via \code{range}. If neither argument specifies the sheet, defaults to the first visible sheet.}

\item{range}{Cells to delete. There are a couple differences between \code{range}
here and how it works in other functions (e.g. \code{\link[=range_read]{range_read()}}):
\itemize{
\item \code{range} must be specified.
\item \code{range} must not be a named range.
\item \code{range} must not be the name of a (work) sheet. Instead, use
\code{\link[=sheet_delete]{sheet_delete()}} to delete an entire sheet.
Row-only and column-only ranges are especially relevant, such as "2:6" or
"D". Remember you can also use the helpers in \code{\link{cell-specification}},
such as \code{cell_cols(4:6)}, or \code{cell_rows(5)}.
}}

\item{shift}{Must be one of "up" or "left", if specified. Required if \code{range}
is NOT a rows-only or column-only range (in which case, we can figure it
out for you). Determines whether the deleted area is filled by shifting
surrounding cells up or to the left.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Deletes a range of cells and shifts other cells into the deleted area. There
are several related tasks that are implemented by other functions:
\itemize{
\item To clear cells of their value and/or format, use \code{\link[=range_clear]{range_clear()}}.
\item To delete an entire (work)sheet, use \code{\link[=sheet_delete]{sheet_delete()}}.
\item To change the dimensions of a (work)sheet, use \code{\link[=sheet_resize]{sheet_resize()}}.
}
}
\examples{
if (gs4_has_token()) {
  # create a data frame to use as initial data
  df <- gs4_fodder(10)

  # create Sheet
  ss <- gs4_create("range-delete-example", sheets = list(df))

  # delete some rows
  range_delete(ss, range = "2:4")

  # delete a column
  range_delete(ss, range = "C")

  # delete a rectangle and specify how to shift remaining cells
  range_delete(ss, range = "B3:F4", shift = "left")

  # clean up
  gs4_find("range-delete-example") \%>\%
    googledrive::drive_trash()
}
}
\seealso{
Makes a \code{DeleteRangeRequest}:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#DeleteRangeRequest}
}

Other write functions: 
\code{\link{gs4_create}()},
\code{\link{gs4_formula}()},
\code{\link{range_flood}()},
\code{\link{range_write}()},
\code{\link{sheet_append}()},
\code{\link{sheet_write}()}
}
\concept{write functions}
