% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_auth}
\alias{drive_auth}
\title{Authorize googledrive}
\usage{
drive_auth(oauth_token = NULL, service_token = NULL, reset = FALSE,
  cache = getOption("httr_oauth_cache"),
  use_oob = getOption("httr_oob_default"), verbose = TRUE)
}
\arguments{
\item{oauth_token}{Optional; path to an \code{.rds} file with a previously stored
OAuth token.}

\item{service_token}{Optional; a JSON string, URL, or path, giving or
pointing to the service token file.}

\item{reset}{Logical, defaults to \code{FALSE}. Set to \code{TRUE} if you want to
forget any token previously used in this session and start afresh. Disables
the \code{.httr-oauth} file in current working directory by renaming to
\code{.httr-oauth-SUSPENDED}.}

\item{cache}{A logical value or a string. \code{TRUE} means to cache
using the default cache file \code{.httr-oauth}, \code{FALSE} means
don't cache, and \code{NA} means to guess using some sensible heuristics.
A string mean use the specified path as the cache file.}

\item{use_oob}{if FALSE, use a local webserver for the OAuth dance.
Otherwise, provide a URL to the user and prompt for a validation
code. Defaults to the of the \code{"httr_oob_default"} default,
or \code{TRUE} if \code{httpuv} is not installed.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\description{
Authorize googledrive to view and manage your Drive files. By default, you
are directed to a web browser, asked to sign in to your Google account,
and to grant googledrive (the tidyverse, actually) permission to operate on
your behalf with Google Drive. By default, these user credentials are cached
in a file named \code{.httr-oauth} in the current working directory, from where
they can be automatically refreshed, as necessary.
}
\details{
Most users, most of the time, do not need to call \code{drive_auth()} explicitly
-- it is triggered by the first action that requires authorization. Even when
called, the default arguments will often suffice. However, when necessary,
this function allows the user to
\itemize{
\item force the adoption of a new token, via \code{reset = TRUE}
\item retrieve current token, e.g., for storage to an \code{.rds} file
\item put a pre-existing OAuth or service account token into force
\item prevent the caching of new, interactively-obtained credentials in
\code{.httr-oauth}
}

For even deeper control over auth, use \code{\link[=drive_auth_config]{drive_auth_config()}} to use your own
OAuth app or API key. \code{\link[=drive_auth_config]{drive_auth_config()}} also allows you to
deactivate auth, sending only an API key in requests, which works if you
only need to access public data.
}
\examples{
\dontrun{
## load/refresh existing credentials, if available
## otherwise, go to browser for authentication and authorization
drive_auth()

## force a new oauth token to be obtained
drive_auth(reset = TRUE)

## store token in an object and then to file
ttt <- drive_auth()
saveRDS(ttt, "ttt.rds")

## load a pre-existing token
drive_auth("ttt.rds") # from .rds file

## use a service account token
drive_auth(service_token = "foofy-83ee9e7c9c48.json")
}
}
\seealso{
More detail is available from
\href{https://developers.google.com/identity/protocols/OAuth2InstalledApp}{Using OAuth 2.0 for Installed Applications}

Other auth functions: \code{\link{drive_auth_config}},
  \code{\link{drive_deauth}}
}
\concept{auth functions}
